/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.infra.adapter.RoleAdapter;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;

public class RoleAdapterImpl
implements RoleAdapter {
    @Override
    public Role toEntity(io.gravitee.repository.management.model.Role role) {
        if (role == null) {
            return null;
        }
        Role.RoleBuilder role1 = Role.builder();
        role1.id(role.getId());
        role1.name(role.getName());
        role1.referenceId(role.getReferenceId());
        role1.referenceType(this.roleReferenceTypeToReferenceType(role.getReferenceType()));
        role1.scope(this.roleScopeToScope(role.getScope()));
        role1.description(role.getDescription());
        role1.defaultRole(role.isDefaultRole());
        int[] permissions = role.getPermissions();
        if (permissions != null) {
            role1.permissions(Arrays.copyOf(permissions, permissions.length));
        }
        role1.system(role.isSystem());
        if (role.getCreatedAt() != null) {
            role1.createdAt(ZonedDateTime.ofInstant(role.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (role.getUpdatedAt() != null) {
            role1.updatedAt(ZonedDateTime.ofInstant(role.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        return role1.build();
    }

    protected Role.ReferenceType roleReferenceTypeToReferenceType(RoleReferenceType roleReferenceType) {
        if (roleReferenceType == null) {
            return null;
        }
        return switch (roleReferenceType) {
            case RoleReferenceType.ENVIRONMENT -> Role.ReferenceType.ENVIRONMENT;
            case RoleReferenceType.ORGANIZATION -> Role.ReferenceType.ORGANIZATION;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + roleReferenceType);
        };
    }

    protected Role.Scope roleScopeToScope(RoleScope roleScope) {
        if (roleScope == null) {
            return null;
        }
        return switch (roleScope) {
            case RoleScope.API -> Role.Scope.API;
            case RoleScope.APPLICATION -> Role.Scope.APPLICATION;
            case RoleScope.GROUP -> Role.Scope.GROUP;
            case RoleScope.ENVIRONMENT -> Role.Scope.ENVIRONMENT;
            case RoleScope.ORGANIZATION -> Role.Scope.ORGANIZATION;
            case RoleScope.PLATFORM -> Role.Scope.PLATFORM;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + roleScope);
        };
    }
}

