/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.membership.domain_service;

import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.MembershipAuditEvent;
import io.gravitee.apim.core.datetime.TimeProvider;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.membership.crud_service.MembershipCrudService;
import io.gravitee.apim.core.membership.exception.ApiPrimaryOwnerNotFoundException;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.MembershipQueryService;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.common.ReferenceContext;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.Map;
import java.util.Optional;

public class ApiPrimaryOwnerDomainService {
    private final AuditDomainService auditService;
    private final GroupQueryService groupQueryService;
    private final MembershipCrudService membershipCrudService;
    private final MembershipQueryService membershipQueryService;
    private final RoleQueryService roleQueryService;
    private final UserCrudService userCrudService;

    public ApiPrimaryOwnerDomainService(AuditDomainService auditDomainService, GroupQueryService groupQueryService, MembershipCrudService membershipCrudService, MembershipQueryService membershipQueryService, RoleQueryService roleQueryService, UserCrudService userCrudService) {
        this.auditService = auditDomainService;
        this.groupQueryService = groupQueryService;
        this.membershipCrudService = membershipCrudService;
        this.membershipQueryService = membershipQueryService;
        this.roleQueryService = roleQueryService;
        this.userCrudService = userCrudService;
    }

    public PrimaryOwnerEntity getApiPrimaryOwner(String organizationId, String apiId) throws ApiPrimaryOwnerNotFoundException {
        return (PrimaryOwnerEntity)this.findPrimaryOwnerRole(organizationId).flatMap(role -> this.findApiPrimaryOwnerMembership(apiId, (Role)role).flatMap(membership -> switch (membership.getMemberType()) {
            default -> throw new IncompatibleClassChangeError();
            case Membership.Type.USER -> this.findUserPrimaryOwner((Membership)membership);
            case Membership.Type.GROUP -> this.findGroupPrimaryOwner((Membership)membership, role.getId());
        })).orElseThrow(() -> new ApiPrimaryOwnerNotFoundException(apiId));
    }

    public void createApiPrimaryOwnerMembership(String apiId, PrimaryOwnerEntity primaryOwner, AuditInfo auditInfo) {
        this.findPrimaryOwnerRole(auditInfo.organizationId()).ifPresent(role -> {
            Membership membership = Membership.builder().id(UuidString.generateRandom()).referenceId(apiId).referenceType(Membership.ReferenceType.API).roleId(role.getId()).memberId(primaryOwner.id()).memberType(Membership.Type.valueOf(primaryOwner.type().name())).createdAt(TimeProvider.now()).updatedAt(TimeProvider.now()).build();
            this.membershipCrudService.create(membership);
            this.createAuditLog(membership, auditInfo);
        });
    }

    private Optional<Role> findPrimaryOwnerRole(String organizationId) {
        return this.roleQueryService.findApiRole(SystemRole.PRIMARY_OWNER.name(), ReferenceContext.builder().referenceType(ReferenceContext.Type.ORGANIZATION).referenceId(organizationId).build());
    }

    private Optional<Membership> findApiPrimaryOwnerMembership(String apiId, Role role) {
        return this.membershipQueryService.findByReferenceAndRoleId(Membership.ReferenceType.API, apiId, role.getId()).stream().findFirst();
    }

    private Optional<PrimaryOwnerEntity> findUserPrimaryOwner(Membership membership) {
        return this.userCrudService.findBaseUserById(membership.getMemberId()).map(user -> PrimaryOwnerEntity.builder().id(user.getId()).displayName(user.displayName()).email(user.getEmail()).type(PrimaryOwnerEntity.Type.USER).build());
    }

    private Optional<PrimaryOwnerEntity> findGroupPrimaryOwner(Membership membership, String primaryOwnerRoleId) {
        Optional<Group> group = this.groupQueryService.findById(membership.getMemberId());
        Optional user = this.findPrimaryOwnerGroupMember(membership.getMemberId(), primaryOwnerRoleId).flatMap(m -> this.userCrudService.findBaseUserById(m.getMemberId()));
        return group.map(value -> PrimaryOwnerEntity.builder().id(value.getId()).displayName(value.getName()).type(PrimaryOwnerEntity.Type.GROUP).email(user.map(BaseUserEntity::getEmail).orElse(null)).build());
    }

    private Optional<Membership> findPrimaryOwnerGroupMember(String groupId, String primaryOwnerRoleId) {
        return this.membershipQueryService.findByReferenceAndRoleId(Membership.ReferenceType.GROUP, groupId, primaryOwnerRoleId).stream().findFirst();
    }

    private void createAuditLog(Membership membership, AuditInfo auditInfo) {
        Map<AuditProperties, String> properties = switch (membership.getMemberType()) {
            default -> throw new IncompatibleClassChangeError();
            case Membership.Type.USER -> Map.of(AuditProperties.USER, membership.getMemberId());
            case Membership.Type.GROUP -> Map.of(AuditProperties.GROUP, membership.getMemberId());
        };
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(membership.getReferenceId()).event(MembershipAuditEvent.MEMBERSHIP_CREATED).actor(auditInfo.actor()).newValue(membership).createdAt(membership.getCreatedAt()).properties(properties).build());
    }
}

