/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.audit.use_case;

import io.gravitee.apim.core.api.model.ApiAuditQueryFilters;
import io.gravitee.apim.core.audit.domain_service.SearchAuditDomainService;
import io.gravitee.apim.core.audit.model.AuditEntity;
import io.gravitee.common.data.domain.MetadataPage;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SearchApiAuditUseCase {
    private final SearchAuditDomainService searchAuditDomainService;

    public SearchApiAuditUseCase(SearchAuditDomainService searchAuditDomainService) {
        this.searchAuditDomainService = searchAuditDomainService;
    }

    public Output execute(Input input) {
        ApiAuditQueryFilters query = input.query;
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 10));
        MetadataPage<AuditEntity> result = this.searchAuditDomainService.searchApiAudit(query, pageable);
        return new Output(result.getContent(), result.getMetadata(), result.getTotalElements());
    }

    public record Input(ApiAuditQueryFilters query, Optional<Pageable> pageable) {
        public Input(ApiAuditQueryFilters query) {
            this(query, Optional.empty());
        }

        public Input(ApiAuditQueryFilters query, Pageable pageable) {
            this(query, Optional.of(pageable));
        }
    }

    public record Output(List<AuditEntity> data, Map<String, String> metadata, long total) {
    }
}

