/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import com.fasterxml.jackson.core.type.TypeReference;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.v4.plan.NewPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanMode;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper
public interface PlanAdapter {
    public static final Logger LOGGER = LoggerFactory.getLogger(PlanAdapter.class);
    public static final PlanAdapter INSTANCE = (PlanAdapter)Mappers.getMapper(PlanAdapter.class);

    @Mappings(value={@Mapping(source="api", target="apiId"), @Mapping(target="security", expression="java(computeBasePlanEntitySecurityV4(plan))"), @Mapping(target="paths", expression="java(computeBasePlanEntityPaths(plan))")})
    public Plan fromRepository(io.gravitee.repository.management.model.Plan var1);

    @Mappings(value={@Mapping(source="apiId", target="api"), @Mapping(target="security", qualifiedByName={"computeRepositorySecurityType"}), @Mapping(target="securityDefinition", source="security.configuration"), @Mapping(target="definition", source="paths", qualifiedByName={"computeBasePlanEntityPaths"})})
    public io.gravitee.repository.management.model.Plan toRepository(Plan var1);

    public PlanEntity toEntityV4(Plan var1);

    @Mappings(value={@Mapping(target="api", source="apiId"), @Mapping(target="security", conditionQualifiedByName={"mapPlanSecurityTypeV2"}), @Mapping(target="securityDefinition", source="security.configuration")})
    public io.gravitee.rest.api.model.PlanEntity toEntityV2(Plan var1);

    public NewPlanEntity entityToNewPlanEntity(PlanEntity var1);

    public PlanCRD toCRD(Plan var1);

    public PlanEntity toEntityV4(PlanCRD var1);

    public io.gravitee.definition.model.v4.plan.Plan toApiDefinition(PlanCRD var1);

    default public Map<String, io.gravitee.definition.model.v4.plan.Plan> toApiDefinition(Map<String, PlanCRD> source) {
        return source.values().stream().map(planCRD -> Map.entry(planCRD.getId(), INSTANCE.toApiDefinition((PlanCRD)planCRD))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public Set<PlanEntity> toPlanEntityV4(Map<String, PlanCRD> source) {
        return source.values().stream().map(INSTANCE::toEntityV4).collect(Collectors.toSet());
    }

    @Named(value="computeBasePlanEntityMode")
    default public PlanMode computeBasePlanEntityMode(io.gravitee.repository.management.model.Plan plan) {
        return plan.getMode() != null ? PlanMode.valueOf((String)plan.getMode().name()) : PlanMode.STANDARD;
    }

    @Named(value="computeBasePlanEntityStatusV4")
    default public PlanStatus computeBasePlanEntityStatusV4(io.gravitee.repository.management.model.Plan plan) {
        return plan.getStatus() != null ? PlanStatus.valueOf((String)plan.getStatus().name()) : PlanStatus.PUBLISHED;
    }

    @Named(value="computeBasePlanEntityStatusV2")
    default public io.gravitee.rest.api.model.PlanStatus computeBasePlanEntityStatusV2(io.gravitee.repository.management.model.Plan plan) {
        return plan.getStatus() != null ? io.gravitee.rest.api.model.PlanStatus.valueOf((String)plan.getStatus().name()) : io.gravitee.rest.api.model.PlanStatus.PUBLISHED;
    }

    @Named(value="computeBasePlanEntitySecurityV4")
    default public PlanSecurity computeBasePlanEntitySecurityV4(io.gravitee.repository.management.model.Plan plan) {
        if (Plan.PlanMode.PUSH != plan.getMode()) {
            return PlanSecurity.builder().type(PlanSecurityType.valueOf((String)plan.getSecurity().name()).getLabel()).configuration(plan.getSecurityDefinition()).build();
        }
        return null;
    }

    default public io.gravitee.rest.api.model.PlanSecurityType mapPlanSecurityTypeV2(PlanSecurity planSecurity) {
        return planSecurity != null ? io.gravitee.rest.api.model.PlanSecurityType.valueOf((String)PlanSecurityType.valueOfLabel((String)planSecurity.getType()).name()) : io.gravitee.rest.api.model.PlanSecurityType.API_KEY;
    }

    default public PlanSecurityType mapPlanSecurityTypeV4(PlanSecurity planSecurity) {
        return planSecurity != null ? PlanSecurityType.valueOfLabel((String)planSecurity.getType()) : null;
    }

    @Named(value="computeBasePlanEntityPaths")
    default public Map<String, List<Rule>> computeBasePlanEntityPaths(io.gravitee.repository.management.model.Plan plan) {
        if (plan.getDefinition() != null && !plan.getDefinition().isEmpty()) {
            try {
                return (Map)GraviteeJacksonMapper.getInstance().readValue(plan.getDefinition(), (TypeReference)new TypeReference<Map<String, List<Rule>>>(){});
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while generating policy definition", (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    @Named(value="computeBasePlanEntityPaths")
    default public String serializeV2PlanPaths(Map<String, List<Rule>> paths) {
        if (paths != null && !paths.isEmpty()) {
            try {
                return GraviteeJacksonMapper.getInstance().writeValueAsString(paths);
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while serializing v2 plan paths", (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    @Named(value="computeRepositorySecurityType")
    default public Plan.PlanSecurityType computeRepositorySecurityType(PlanSecurity planSecurity) {
        if (planSecurity != null) {
            PlanSecurityType planSecurityType = PlanSecurityType.valueOfLabel((String)planSecurity.getType());
            return Plan.PlanSecurityType.valueOf((String)planSecurityType.name());
        }
        return null;
    }
}

