/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.subscription.domain_service;

import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.ApplicationAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.SubscriptionAuditEvent;
import io.gravitee.apim.core.notification.domain_service.TriggerNotificationDomainService;
import io.gravitee.apim.core.notification.model.Recipient;
import io.gravitee.apim.core.notification.model.hook.SubscriptionRejectedApiHookContext;
import io.gravitee.apim.core.notification.model.hook.SubscriptionRejectedApplicationHookContext;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.subscription.crud_service.SubscriptionCrudService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyClosedException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectSubscriptionDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RejectSubscriptionDomainService.class);
    private final AuditDomainService auditDomainService;
    private final SubscriptionCrudService subscriptionRepository;
    private final PlanCrudService planCrudService;
    private final TriggerNotificationDomainService triggerNotificationDomainService;
    private final UserCrudService userCrudService;

    public RejectSubscriptionDomainService(SubscriptionCrudService subscriptionRepository, PlanCrudService planCrudService, AuditDomainService auditDomainService, TriggerNotificationDomainService triggerNotificationDomainService, UserCrudService userCrudService) {
        this.subscriptionRepository = subscriptionRepository;
        this.planCrudService = planCrudService;
        this.triggerNotificationDomainService = triggerNotificationDomainService;
        this.auditDomainService = auditDomainService;
        this.userCrudService = userCrudService;
    }

    public SubscriptionEntity rejectSubscription(String subscriptionId, AuditInfo auditInfo) {
        log.debug("Close subscription {}", (Object)subscriptionId);
        SubscriptionEntity subscriptionEntity = this.subscriptionRepository.get(subscriptionId);
        return this.rejectSubscription(subscriptionEntity, auditInfo);
    }

    public SubscriptionEntity rejectSubscription(SubscriptionEntity subscriptionEntity, AuditInfo auditInfo) {
        if (subscriptionEntity == null) {
            throw new IllegalArgumentException("Subscription should not be null");
        }
        RejectSubscriptionDomainService.checkSubscriptionStatus(subscriptionEntity);
        this.checkPlanStatus(subscriptionEntity);
        SubscriptionEntity rejectedSubscriptionEntity = subscriptionEntity.rejectBy(auditInfo.actor().userId());
        this.subscriptionRepository.update(rejectedSubscriptionEntity);
        this.triggerNotifications(auditInfo.organizationId(), rejectedSubscriptionEntity);
        this.createAudit(subscriptionEntity, rejectedSubscriptionEntity, auditInfo);
        return rejectedSubscriptionEntity;
    }

    private void triggerNotifications(String organizationId, SubscriptionEntity rejectedSubscriptionEntity) {
        Optional<Recipient> subscriberEmail = this.userCrudService.findBaseUserById(rejectedSubscriptionEntity.getSubscribedBy()).map(BaseUserEntity::getEmail).filter(email -> !email.isEmpty()).map(email -> new Recipient("EMAIL", (String)email));
        List<Recipient> additionalRecipients = subscriberEmail.map(List::of).orElse(Collections.emptyList());
        this.triggerNotificationDomainService.triggerApiNotification(organizationId, new SubscriptionRejectedApiHookContext(rejectedSubscriptionEntity.getApiId(), rejectedSubscriptionEntity.getApplicationId(), rejectedSubscriptionEntity.getPlanId(), rejectedSubscriptionEntity.getId()));
        this.triggerNotificationDomainService.triggerApplicationNotification(organizationId, new SubscriptionRejectedApplicationHookContext(rejectedSubscriptionEntity.getApplicationId(), rejectedSubscriptionEntity.getApiId(), rejectedSubscriptionEntity.getPlanId(), rejectedSubscriptionEntity.getId()), additionalRecipients);
    }

    private static void checkSubscriptionStatus(SubscriptionEntity subscriptionEntity) {
        if (!subscriptionEntity.isPending()) {
            throw new IllegalStateException("Cannot reject subscription");
        }
    }

    private void createAudit(SubscriptionEntity subscriptionEntity, SubscriptionEntity rejectedSubscriptionEntity, AuditInfo auditInfo) {
        this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().actor(auditInfo.actor()).organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(subscriptionEntity.getApiId()).event(SubscriptionAuditEvent.SUBSCRIPTION_UPDATED).oldValue(subscriptionEntity).newValue(rejectedSubscriptionEntity).createdAt(rejectedSubscriptionEntity.getClosedAt()).properties(Collections.singletonMap(AuditProperties.APPLICATION, subscriptionEntity.getApplicationId())).build());
        this.auditDomainService.createApplicationAuditLog(ApplicationAuditLogEntity.builder().actor(auditInfo.actor()).organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).applicationId(subscriptionEntity.getApplicationId()).event(SubscriptionAuditEvent.SUBSCRIPTION_UPDATED).oldValue(subscriptionEntity).newValue(rejectedSubscriptionEntity).createdAt(rejectedSubscriptionEntity.getClosedAt()).properties(Collections.singletonMap(AuditProperties.API, subscriptionEntity.getApiId())).build());
    }

    private void checkPlanStatus(SubscriptionEntity subscriptionEntity) {
        Plan plan = this.planCrudService.findById(subscriptionEntity.getPlanId());
        if (plan.isClosed()) {
            throw new PlanAlreadyClosedException(plan.getId());
        }
    }
}

