/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plugin.use_case;

import io.gravitee.apim.core.plugin.domain_service.PluginFilterByLicenseDomainService;
import io.gravitee.apim.core.plugin.model.PlatformPlugin;
import io.gravitee.apim.core.plugin.model.PolicyPlugin;
import io.gravitee.apim.core.plugin.query_service.PolicyPluginQueryService;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class GetPolicyPluginsUseCase {
    private final PolicyPluginQueryService policyPluginQueryService;
    private final PluginFilterByLicenseDomainService licenseChecker;

    public GetPolicyPluginsUseCase(PolicyPluginQueryService policyPluginQueryService, PluginFilterByLicenseDomainService licenseChecker) {
        this.policyPluginQueryService = policyPluginQueryService;
        this.licenseChecker = licenseChecker;
    }

    public Output getPoliciesByOrganization(Input input) {
        return new Output(this.licenseChecker.setPluginDeployedStatusDependingOnLicense(this.policyPluginQueryService.findAll(), input.organizationId).stream().collect(Collectors.toCollection(() -> new TreeSet<PolicyPlugin>(Comparator.comparing(PlatformPlugin::getName)))));
    }

    public record Output(Set<PolicyPlugin> plugins) {
    }

    public record Input(String organizationId) {
    }
}

