/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.use_case;

import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.model.PlanWithFlows;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.util.List;
import lombok.Generated;

public class CreatePlanUseCase {
    private final CreatePlanDomainService createPlanDomainService;
    private final ApiCrudService apiCrudService;

    public Output execute(Input input) {
        Plan plan = input.plan;
        plan.setApiId(input.apiId);
        plan.setType(Plan.PlanType.API);
        plan.setStatus(PlanStatus.STAGING);
        if (plan.getMode() == null) {
            plan.setMode(PlanMode.STANDARD);
        }
        PlanWithFlows createdPlan = this.createPlanDomainService.create(input.plan, input.flows == null ? List.of() : input.flows, this.apiCrudService.get(input.apiId()), input.auditInfo);
        return new Output(createdPlan.getId(), createdPlan);
    }

    @Generated
    public CreatePlanUseCase(CreatePlanDomainService createPlanDomainService, ApiCrudService apiCrudService) {
        this.createPlanDomainService = createPlanDomainService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(String apiId, Plan plan, List<Flow> flows, AuditInfo auditInfo) {
    }

    public record Output(String id, PlanWithFlows plan) {
    }
}

