/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.environment.EnvironmentCommand;
import io.gravitee.cockpit.api.command.environment.EnvironmentPayload;
import io.gravitee.cockpit.api.command.environment.EnvironmentReply;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.UpdateEnvironmentEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentCommandHandler
implements CommandHandler<EnvironmentCommand, EnvironmentReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentCommandHandler.class);
    private final EnvironmentService environmentService;
    private final AccessPointCrudService accessPointService;

    public Command.Type handleType() {
        return Command.Type.ENVIRONMENT_COMMAND;
    }

    public Single<EnvironmentReply> handle(EnvironmentCommand command) {
        EnvironmentPayload environmentPayload = (EnvironmentPayload)command.getPayload();
        try {
            EnvironmentEntity existingEnvironment = this.getEnvironment(environmentPayload);
            UpdateEnvironmentEntity newEnvironment = new UpdateEnvironmentEntity();
            newEnvironment.setCockpitId(environmentPayload.getCockpitId());
            newEnvironment.setHrids(environmentPayload.getHrids());
            newEnvironment.setName(environmentPayload.getName());
            newEnvironment.setDescription(environmentPayload.getDescription());
            EnvironmentEntity environment = this.environmentService.createOrUpdate(existingEnvironment != null ? existingEnvironment.getOrganizationId() : environmentPayload.getOrganizationId(), existingEnvironment != null ? existingEnvironment.getId() : environmentPayload.getId(), newEnvironment);
            List<Object> accessPointsToCreate = environmentPayload.getAccessPoints() != null ? environmentPayload.getAccessPoints().stream().map(cockpitAccessPoint -> AccessPoint.builder().referenceType(AccessPoint.ReferenceType.ENVIRONMENT).referenceId(environment.getId()).target(AccessPoint.Target.valueOf(cockpitAccessPoint.getTarget().name())).host(cockpitAccessPoint.getHost()).secured(cockpitAccessPoint.isSecured()).overriding(cockpitAccessPoint.isOverriding()).build()).toList() : new ArrayList();
            this.accessPointService.updateAccessPoints(AccessPoint.ReferenceType.ENVIRONMENT, environment.getId(), accessPointsToCreate);
            log.info("Environment [{}] handled with id [{}].", (Object)environment.getName(), (Object)environment.getId());
            return Single.just((Object)new EnvironmentReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception e) {
            log.error("Error occurred when handling environment [{}] with id [{}].", new Object[]{environmentPayload.getName(), environmentPayload.getId(), e});
            return Single.just((Object)new EnvironmentReply(command.getId(), CommandStatus.ERROR));
        }
    }

    private EnvironmentEntity getEnvironment(EnvironmentPayload environmentPayload) {
        try {
            return this.environmentService.findByCockpitId(environmentPayload.getCockpitId());
        }
        catch (EnvironmentNotFoundException ex) {
            return null;
        }
    }

    @Generated
    public EnvironmentCommandHandler(EnvironmentService environmentService, AccessPointCrudService accessPointService) {
        this.environmentService = environmentService;
        this.accessPointService = accessPointService;
    }
}

