/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.apim.core.api.domain_service.VerifyApiPathDomainService;
import io.gravitee.apim.core.api.exception.InvalidPathsException;
import io.gravitee.apim.core.api.model.Path;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.NewPlanEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiEntityResult;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.cockpit.model.ContextPathValidationResult;
import io.gravitee.rest.api.service.cockpit.model.DeploymentMode;
import io.gravitee.rest.api.service.cockpit.services.ApiServiceCockpit;
import io.gravitee.rest.api.service.cockpit.services.ImportSwaggerDescriptorBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.converter.PageConverter;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiServiceCockpitImpl
implements ApiServiceCockpit {
    private final Logger logger = LoggerFactory.getLogger(ApiServiceCockpitImpl.class);
    private final ObjectMapper objectMapper;
    private final ApiService apiService;
    private final ApiConverter apiConverter;
    private final SwaggerService swaggerService;
    private final PageService pageService;
    private final ApiMetadataService apiMetadataService;
    private final PlanService planService;
    private final PageConverter pageConverter;
    private final VerifyApiPathDomainService verifyApiPathDomainService;

    public ApiServiceCockpitImpl(ObjectMapper objectMapper, ApiService apiService, SwaggerService swaggerService, PageService pageService, ApiMetadataService apiMetadataService, PlanService planService, ApiConverter apiConverter, PageConverter pageConverter, VerifyApiPathDomainService verifyApiPathDomainService) {
        this.objectMapper = objectMapper;
        this.apiService = apiService;
        this.swaggerService = swaggerService;
        this.pageService = pageService;
        this.apiMetadataService = apiMetadataService;
        this.planService = planService;
        this.apiConverter = apiConverter;
        this.pageConverter = pageConverter;
        this.verifyApiPathDomainService = verifyApiPathDomainService;
    }

    @Override
    public ApiEntityResult createApi(ExecutionContext executionContext, String apiId, String userId, String swaggerDefinition, String environmentId, DeploymentMode mode, List<String> labels) {
        if (mode == DeploymentMode.API_MOCKED) {
            this.logger.debug("Create Mocked Api [{}].", (Object)apiId);
            return this.createMockedApi(executionContext, apiId, userId, swaggerDefinition, environmentId, labels);
        }
        if (mode == DeploymentMode.API_PUBLISHED) {
            this.logger.debug("Create Published Api [{}].", (Object)apiId);
            return this.createPublishedApi(executionContext, apiId, userId, swaggerDefinition, environmentId, labels);
        }
        this.logger.debug("Create Documented Api [{}].", (Object)apiId);
        return this.createDocumentedApi(executionContext, apiId, userId, swaggerDefinition, labels);
    }

    @Override
    public ApiEntityResult updateApi(ExecutionContext executionContext, String apiId, String userId, String swaggerDefinition, String environmentId, DeploymentMode mode, List<String> labels) {
        if (mode == DeploymentMode.API_DOCUMENTED) {
            this.logger.debug("Update Documented Api [{}].", (Object)apiId);
            return this.updateDocumentedApi(executionContext, apiId, swaggerDefinition, labels);
        }
        if (mode == DeploymentMode.API_MOCKED) {
            this.logger.debug("Update Mocked Api [{}].", (Object)apiId);
            return this.updateMockedApi(executionContext, apiId, userId, swaggerDefinition, environmentId, labels);
        }
        this.logger.debug("Update Published Api [{}].", (Object)apiId);
        return this.updatePublishedApi(executionContext, apiId, userId, swaggerDefinition, environmentId, labels);
    }

    private ApiEntityResult createDocumentedApi(ExecutionContext executionContext, String apiId, String userId, String swaggerDefinition, List<String> labels) {
        ImportSwaggerDescriptorEntity swaggerDescriptor = ImportSwaggerDescriptorBuilder.buildForDocumentedApi(swaggerDefinition);
        return this.createApiEntity(executionContext, apiId, userId, swaggerDescriptor, labels);
    }

    private ApiEntityResult updateDocumentedApi(ExecutionContext executionContext, String apiId, String swaggerDefinition, List<String> labels) {
        return this.updateApiEntity(executionContext, apiId, ImportSwaggerDescriptorBuilder.buildForDocumentedApi(swaggerDefinition), labels);
    }

    private ApiEntityResult createMockedApi(ExecutionContext executionContext, String apiId, String userId, String swaggerDefinition, String environmentId, List<String> labels) {
        ImportSwaggerDescriptorEntity swaggerDescriptor = ImportSwaggerDescriptorBuilder.buildForMockedApi(swaggerDefinition);
        ApiEntityResult createApiResult = this.createApiEntity(executionContext, apiId, userId, swaggerDescriptor, labels);
        if (createApiResult.isSuccess()) {
            String createdApiId = createApiResult.getApi().getId();
            this.planService.create(executionContext, this.createKeylessPlan(createdApiId, environmentId));
            return ApiEntityResult.success((ApiEntity)this.apiService.start(executionContext, createdApiId, userId));
        }
        return createApiResult;
    }

    private ApiEntityResult updateMockedApi(ExecutionContext executionContext, String apiId, String userId, String swaggerDefinition, String environmentId, List<String> labels) {
        ApiEntity apiEntity;
        ApiEntityResult apiEntityResult = this.updateApiEntity(executionContext, apiId, ImportSwaggerDescriptorBuilder.buildForMockedApi(swaggerDefinition), labels);
        ApiDeploymentEntity apiDeployment = new ApiDeploymentEntity();
        apiDeployment.setDeploymentLabel("Model updated");
        Set<PlanEntity> plans = this.planService.findByApi(executionContext, apiId);
        if (null == plans || plans.isEmpty()) {
            this.planService.create(executionContext, this.createKeylessPlan(apiId, environmentId));
        }
        if (null != (apiEntity = apiEntityResult.getApi()) && Lifecycle.State.STOPPED.equals((Object)apiEntity.getState())) {
            this.apiService.start(executionContext, apiId, userId);
        }
        return ApiEntityResult.success((ApiEntity)this.apiService.deploy(executionContext, apiId, userId, EventType.PUBLISH_API, apiDeployment));
    }

    private ApiEntityResult createPublishedApi(ExecutionContext executionContext, String apiId, String userId, String swaggerDefinition, String environmentId, List<String> labels) {
        ImportSwaggerDescriptorEntity swaggerDescriptor = ImportSwaggerDescriptorBuilder.buildForMockedApi(swaggerDefinition);
        ApiEntityResult createApiResult = this.createApiEntity(executionContext, apiId, userId, swaggerDescriptor, labels);
        if (createApiResult.isSuccess()) {
            String createdApiId = createApiResult.getApi().getId();
            this.planService.create(executionContext, this.createKeylessPlan(createdApiId, environmentId));
            ApiEntity apiEntity = this.apiService.start(executionContext, createdApiId, userId);
            this.publishSwaggerDocumentation(executionContext, createdApiId);
            UpdateApiEntity updateEntity = this.apiConverter.toUpdateApiEntity(apiEntity);
            updateEntity.setVisibility(Visibility.PUBLIC);
            updateEntity.setLifecycleState(ApiLifecycleState.PUBLISHED);
            return ApiEntityResult.success((ApiEntity)this.apiService.update(executionContext, createdApiId, updateEntity));
        }
        return createApiResult;
    }

    private ApiEntityResult updatePublishedApi(ExecutionContext executionContext, String apiId, String userId, String swaggerDefinition, String environmentId, List<String> labels) {
        ApiEntityResult updatedApiResult = this.updateMockedApi(executionContext, apiId, userId, swaggerDefinition, environmentId, labels);
        if (updatedApiResult.isSuccess() && !ApiLifecycleState.PUBLISHED.equals((Object)updatedApiResult.getApi().getLifecycleState())) {
            this.publishSwaggerDocumentation(executionContext, apiId);
            UpdateApiEntity updateEntity = this.apiConverter.toUpdateApiEntity(updatedApiResult.getApi());
            updateEntity.setVisibility(Visibility.PUBLIC);
            updateEntity.setLifecycleState(ApiLifecycleState.PUBLISHED);
            return ApiEntityResult.success((ApiEntity)this.apiService.update(executionContext, apiId, updateEntity));
        }
        return updatedApiResult;
    }

    private ApiEntityResult updateApiEntity(ExecutionContext executionContext, String apiId, ImportSwaggerDescriptorEntity swaggerDescriptor, List<String> labels) {
        SwaggerApiEntity api = this.swaggerService.createAPI(executionContext, swaggerDescriptor, DefinitionVersion.V2);
        api.setPaths(null);
        api.setLabels(labels);
        ContextPathValidationResult result = this.checkContextPath(executionContext.getEnvironmentId(), api);
        if (result.hasError()) {
            return ApiEntityResult.failure((String)result.getError());
        }
        api.getProxy().setVirtualHosts(result.toVirtualHosts());
        return ApiEntityResult.success((ApiEntity)this.apiService.updateFromSwagger(executionContext, apiId, api, swaggerDescriptor));
    }

    private ApiEntityResult createApiEntity(ExecutionContext executionContext, String apiId, String userId, ImportSwaggerDescriptorEntity swaggerDescriptor, List<String> labels) {
        SwaggerApiEntity api = this.swaggerService.createAPI(executionContext, swaggerDescriptor, DefinitionVersion.V2);
        api.setPaths(null);
        api.setLabels(labels);
        ContextPathValidationResult result = this.checkContextPath(executionContext.getEnvironmentId(), api);
        if (result.hasError()) {
            return ApiEntityResult.failure((String)result.getError());
        }
        api.getProxy().setVirtualHosts(result.toVirtualHosts());
        ObjectNode apiDefinition = (ObjectNode)this.objectMapper.valueToTree((Object)api);
        apiDefinition.put("crossId", apiId);
        api.setCrossId(apiId);
        ApiEntity createdApi = this.apiService.createWithApiDefinition(executionContext, (UpdateApiEntity)api, userId, (JsonNode)apiDefinition);
        this.pageService.createAsideFolder(executionContext, createdApi.getId());
        this.pageService.createOrUpdateSwaggerPage(executionContext, createdApi.getId(), swaggerDescriptor, true);
        this.apiMetadataService.create(executionContext, api.getMetadata(), createdApi.getId());
        return ApiEntityResult.success((ApiEntity)createdApi);
    }

    ContextPathValidationResult checkContextPath(String environmentId, SwaggerApiEntity api) {
        return this.checkContextPath(environmentId, api, null);
    }

    ContextPathValidationResult checkContextPath(String environmentId, SwaggerApiEntity api, String apiId) {
        try {
            List<Path> sanitizedPaths = this.verifyApiPathDomainService.checkAndSanitizeApiPaths(environmentId, apiId, api.getProxy().getVirtualHosts().stream().map(h -> Path.builder().path(h.getPath()).host(h.getHost()).overrideAccess(h.isOverrideEntrypoint()).build()).toList());
            return ContextPathValidationResult.builder().sanitizedPaths(sanitizedPaths).build();
        }
        catch (InvalidPathsException e) {
            String ctxPath = api.getProxy().getVirtualHosts().stream().findFirst().map(VirtualHost::getPath).orElse("");
            return ContextPathValidationResult.builder().error("The path [" + ctxPath + "] automatically generated from the name is already covered by another API.").build();
        }
        catch (Exception e) {
            return ContextPathValidationResult.builder().error(e.getMessage()).build();
        }
    }

    private NewPlanEntity createKeylessPlan(String apiId, String environmentId) {
        NewPlanEntity plan = new NewPlanEntity();
        plan.setId(UuidString.generateForEnvironment(environmentId, apiId));
        plan.setName("Keyless plan");
        plan.setSecurity(PlanSecurityType.KEY_LESS);
        plan.setApi(apiId);
        plan.setStatus(PlanStatus.PUBLISHED);
        return plan;
    }

    private void publishSwaggerDocumentation(ExecutionContext executionContext, String apiId) {
        PageEntity page;
        List<PageEntity> apiDocs = this.pageService.search(executionContext.getEnvironmentId(), new PageQuery.Builder().api(apiId).type(PageType.SWAGGER).build());
        if (apiDocs.isEmpty()) {
            this.logger.error("No swagger documentation to publish");
            return;
        }
        if (apiDocs.size() > 1) {
            this.logger.error("More than one swagger documentation, this should not happen");
        }
        if (!(page = apiDocs.get(0)).isPublished()) {
            UpdatePageEntity updatePage = this.pageConverter.toUpdatePageEntity(page);
            updatePage.setPublished(Boolean.valueOf(true));
            this.pageService.update(executionContext, page.getId(), updatePage);
        }
    }
}

