/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.apim.core.api.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.exception.ApiPrimaryOwnerNotFoundException;
import io.gravitee.apim.infra.adapter.PrimaryOwnerAdapter;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.GroupNotFoundException;
import io.gravitee.rest.api.service.exceptions.NoPrimaryOwnerGroupForUserException;
import io.gravitee.rest.api.service.exceptions.NonPoGroupException;
import io.gravitee.rest.api.service.exceptions.PrimaryOwnerNotFoundException;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PrimaryOwnerServiceImpl
extends TransactionalService
implements PrimaryOwnerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrimaryOwnerServiceImpl.class);
    private final UserService userService;
    private final MembershipService membershipService;
    private final GroupService groupService;
    private final ParameterService parameterService;
    private final RoleService roleService;
    private final ApiPrimaryOwnerDomainService primaryOwnerDomainService;

    public PrimaryOwnerServiceImpl(UserService userService, MembershipService membershipService, GroupService groupService, ParameterService parameterService, RoleService roleService, ApiPrimaryOwnerDomainService primaryOwnerDomainService) {
        this.userService = userService;
        this.membershipService = membershipService;
        this.groupService = groupService;
        this.parameterService = parameterService;
        this.roleService = roleService;
        this.primaryOwnerDomainService = primaryOwnerDomainService;
    }

    @Override
    public PrimaryOwnerEntity getPrimaryOwner(String organizationId, String apiId) throws TechnicalManagementException {
        try {
            io.gravitee.apim.core.membership.model.PrimaryOwnerEntity po = this.primaryOwnerDomainService.getApiPrimaryOwner(organizationId, apiId);
            return PrimaryOwnerAdapter.INSTANCE.toRestEntity(po);
        }
        catch (ApiPrimaryOwnerNotFoundException e) {
            throw new PrimaryOwnerNotFoundException(e.getApiId());
        }
    }

    @Override
    public String getPrimaryOwnerEmail(String organizationId, String apiId) {
        try {
            io.gravitee.apim.core.membership.model.PrimaryOwnerEntity po = this.primaryOwnerDomainService.getApiPrimaryOwner(organizationId, apiId);
            return po.email();
        }
        catch (ApiPrimaryOwnerNotFoundException e) {
            throw new PrimaryOwnerNotFoundException(e.getApiId());
        }
    }

    @Override
    public PrimaryOwnerEntity getPrimaryOwner(ExecutionContext executionContext, String userId, PrimaryOwnerEntity currentPrimaryOwner) {
        ApiPrimaryOwnerMode poMode = ApiPrimaryOwnerMode.valueOf((String)this.parameterService.find(executionContext, Key.API_PRIMARY_OWNER_MODE, ParameterReferenceType.ENVIRONMENT));
        switch (poMode) {
            case USER: {
                if (currentPrimaryOwner == null || ApiPrimaryOwnerMode.GROUP.name().equals(currentPrimaryOwner.getType())) {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
                }
                if (!ApiPrimaryOwnerMode.USER.name().equals(currentPrimaryOwner.getType())) break;
                try {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, currentPrimaryOwner.getId()));
                }
                catch (UserNotFoundException unfe) {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
                }
            }
            case GROUP: {
                if (currentPrimaryOwner == null) {
                    return this.getFirstPoGroupUserBelongsTo(executionContext, userId);
                }
                if (ApiPrimaryOwnerMode.GROUP.name().equals(currentPrimaryOwner.getType())) {
                    try {
                        GroupEntity group2 = this.groupService.findById(executionContext, currentPrimaryOwner.getId());
                        if (!group2.isPrimaryOwner()) {
                            throw new NonPoGroupException(currentPrimaryOwner.getId());
                        }
                        String poMail = this.computePrimaryOwnerMailFromGroup(executionContext, currentPrimaryOwner.getId());
                        return new PrimaryOwnerEntity(group2, poMail);
                    }
                    catch (GroupNotFoundException unfe) {
                        return this.getFirstPoGroupUserBelongsTo(executionContext, userId);
                    }
                }
                if (!ApiPrimaryOwnerMode.USER.name().equals(currentPrimaryOwner.getType())) break;
                try {
                    String poUserId = currentPrimaryOwner.getId();
                    this.userService.findById(executionContext, poUserId);
                    Set poGroupsOfPoUser = this.groupService.findByUser(poUserId).stream().filter(group -> group.getApiPrimaryOwner() != null && !group.getApiPrimaryOwner().isEmpty()).collect(Collectors.toSet());
                    if (poGroupsOfPoUser.isEmpty()) {
                        return this.getFirstPoGroupUserBelongsTo(executionContext, userId);
                    }
                    GroupEntity groupEntity = (GroupEntity)poGroupsOfPoUser.iterator().next();
                    String poMail = this.computePrimaryOwnerMailFromGroup(executionContext, groupEntity.getId());
                    return new PrimaryOwnerEntity(groupEntity, poMail);
                }
                catch (UserNotFoundException unfe) {
                    return this.getFirstPoGroupUserBelongsTo(executionContext, userId);
                }
            }
            default: {
                if (currentPrimaryOwner == null) {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
                }
                if (ApiPrimaryOwnerMode.GROUP.name().equals(currentPrimaryOwner.getType())) {
                    try {
                        GroupEntity group3 = this.groupService.findById(executionContext, currentPrimaryOwner.getId());
                        if (!group3.isPrimaryOwner()) {
                            throw new NonPoGroupException(currentPrimaryOwner.getId());
                        }
                        String poMail = this.computePrimaryOwnerMailFromGroup(executionContext, currentPrimaryOwner.getId());
                        return new PrimaryOwnerEntity(group3, poMail);
                    }
                    catch (GroupNotFoundException unfe) {
                        try {
                            return this.getFirstPoGroupUserBelongsTo(executionContext, userId);
                        }
                        catch (NoPrimaryOwnerGroupForUserException ex) {
                            return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
                        }
                    }
                }
                if (!ApiPrimaryOwnerMode.USER.name().equals(currentPrimaryOwner.getType())) break;
                try {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, currentPrimaryOwner.getId()));
                }
                catch (UserNotFoundException unfe) {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
                }
            }
        }
        return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
    }

    @NotNull
    private PrimaryOwnerEntity getFirstPoGroupUserBelongsTo(ExecutionContext executionContext, String userId) {
        Set poGroupsOfCurrentUser = this.groupService.findByUser(userId).stream().filter(group -> !StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner())).collect(Collectors.toSet());
        if (poGroupsOfCurrentUser.isEmpty()) {
            throw new NoPrimaryOwnerGroupForUserException(userId);
        }
        GroupEntity group2 = (GroupEntity)poGroupsOfCurrentUser.iterator().next();
        String poMail = this.computePrimaryOwnerMailFromGroup(executionContext, group2.getId());
        return new PrimaryOwnerEntity(group2, poMail);
    }

    @Override
    public Map<String, PrimaryOwnerEntity> getPrimaryOwners(ExecutionContext executionContext, List<String> apiIds) {
        if (apiIds == null || apiIds.isEmpty()) {
            return Map.of();
        }
        RoleEntity primaryOwnerRole = this.roleService.findPrimaryOwnerRoleByOrganization(executionContext.getOrganizationId(), RoleScope.API);
        if (primaryOwnerRole == null) {
            throw new RoleNotFoundException("API_PRIMARY_OWNER");
        }
        Set<MemberEntity> memberships = this.membershipService.getMembersByReferencesAndRole(executionContext, MembershipReferenceType.API, apiIds, primaryOwnerRole.getId());
        HashMap primaryOwnerIdToPrimaryOwnerEntity = new HashMap(memberships.size());
        ArrayList<String> userIds = new ArrayList<String>();
        HashSet<String> groupIds = new HashSet<String>();
        memberships.forEach(memberEntity -> {
            if (memberEntity.getType() == MembershipMemberType.USER) {
                userIds.add(memberEntity.getId());
            } else if (memberEntity.getType() == MembershipMemberType.GROUP) {
                groupIds.add(memberEntity.getId());
            }
        });
        if (!userIds.isEmpty()) {
            this.userService.findByIds(executionContext, userIds).forEach(userEntity -> primaryOwnerIdToPrimaryOwnerEntity.put(userEntity.getId(), new PrimaryOwnerEntity(userEntity)));
        }
        if (!groupIds.isEmpty()) {
            this.groupService.findByIds(groupIds).forEach(groupEntity -> {
                String poMail = this.computePrimaryOwnerMailFromGroup(executionContext, groupEntity.getId());
                primaryOwnerIdToPrimaryOwnerEntity.put(groupEntity.getId(), new PrimaryOwnerEntity(groupEntity, poMail));
            });
        }
        return memberships.stream().filter(memberEntity -> primaryOwnerIdToPrimaryOwnerEntity.containsKey(memberEntity.getId())).collect(Collectors.toMap(MemberEntity::getReferenceId, memberEntity -> (PrimaryOwnerEntity)primaryOwnerIdToPrimaryOwnerEntity.get(memberEntity.getId())));
    }

    @NotNull
    private String computePrimaryOwnerMailFromGroup(ExecutionContext executionContext, String groupId) {
        Set<MemberEntity> members = this.membershipService.getMembersByReference(executionContext, MembershipReferenceType.GROUP, groupId);
        return members.stream().filter(member -> member.getRoles().stream().anyMatch(RoleEntity::isApiPrimaryOwner)).findFirst().map(MemberEntity::getEmail).orElse("");
    }
}

