/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.FlowRepository;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.TagEntity;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.FlowService;
import io.gravitee.rest.api.service.v4.mapper.FlowMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="FlowServiceImplV4")
public class FlowServiceImpl
extends TransactionalService
implements FlowService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowServiceImpl.class);
    private final FlowRepository flowRepository;
    private final TagService tagService;
    private final FlowMapper flowMapper;

    public FlowServiceImpl(@Lazy FlowRepository flowRepository, TagService tagService, FlowMapper flowMapper) {
        this.flowRepository = flowRepository;
        this.tagService = tagService;
        this.flowMapper = flowMapper;
    }

    private String getFileContent(String path) {
        String string;
        block8: {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(path);
            try {
                string = IOUtils.toString((InputStream)resourceAsStream, (Charset)Charset.defaultCharset());
                if (resourceAsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TechnicalManagementException("An error occurs while trying load flow configuration", e);
                }
            }
            resourceAsStream.close();
        }
        return string;
    }

    @Override
    public String getConfigurationSchemaForm() {
        return this.getFileContent("/flow/configuration-schema-form.json");
    }

    @Override
    public String getApiFlowSchemaForm() {
        return this.getFileContent("/flow/v4/api-flow-schema-form.json");
    }

    @Override
    public String getPlatformFlowSchemaForm(ExecutionContext executionContext) {
        log.debug("Get platform schema form");
        String fileContent = this.getFileContent("/flow/v4/platform-flow-schema-form.json");
        List<TagEntity> tags = this.tagService.findByReference(executionContext.getOrganizationId(), TagReferenceType.ORGANIZATION);
        if (tags.size() > 0) {
            log.debug("Append {} tag(s) to platform schema form", (Object)tags.size());
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonSchema = mapper.readTree(fileContent);
                ObjectNode tagsNode = (ObjectNode)jsonSchema.get("properties").get("tags");
                ArrayNode enumNode = (ArrayNode)tagsNode.get("items").get("enum");
                HashMap titleMap = new HashMap();
                tags.forEach(tagEntity -> titleMap.put(tagEntity.getId(), tagEntity.getName()));
                titleMap.keySet().forEach(arg_0 -> ((ArrayNode)enumNode).add(arg_0));
                JsonNode titleMapNode = mapper.valueToTree(titleMap);
                ObjectNode xSchemaForm = mapper.createObjectNode();
                tagsNode.set("x-schema-form", (JsonNode)xSchemaForm);
                xSchemaForm.set("titleMap", titleMapNode);
                return jsonSchema.toPrettyString();
            }
            catch (JsonProcessingException ex) {
                String error = "An error occurs while append tags to platform flow schema form";
                log.error("An error occurs while append tags to platform flow schema form", (Throwable)ex);
                throw new TechnicalManagementException("An error occurs while append tags to platform flow schema form", ex);
            }
        }
        return fileContent;
    }

    @Override
    public List<Flow> findByReference(FlowReferenceType flowReferenceType, String referenceId) {
        try {
            log.debug("Find flows by reference {} - {}", (Object)flowReferenceType, (Object)flowReferenceType);
            return this.flowRepository.findByReference(flowReferenceType, referenceId).stream().sorted(Comparator.comparing(io.gravitee.repository.management.model.flow.Flow::getOrder)).map(this.flowMapper::toDefinition).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while find flows by reference";
            log.error("An error occurs while find flows by reference", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while find flows by reference", ex);
        }
    }

    @Override
    public List<Flow> save(FlowReferenceType flowReferenceType, String referenceId, List<Flow> flows) {
        try {
            log.debug("Save flows for reference {},{}", (Object)flowReferenceType, (Object)flowReferenceType);
            this.flowRepository.deleteByReference(flowReferenceType, referenceId);
            if (flows == null) {
                return List.of();
            }
            ArrayList<Flow> createdFlows = new ArrayList<Flow>();
            for (int order = 0; order < flows.size(); ++order) {
                io.gravitee.repository.management.model.flow.Flow createdFlow = (io.gravitee.repository.management.model.flow.Flow)this.flowRepository.create((Object)this.flowMapper.toRepository(flows.get(order), flowReferenceType, referenceId, order));
                createdFlows.add(this.flowMapper.toDefinition(createdFlow));
            }
            return createdFlows;
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while save flows";
            log.error("An error occurs while save flows", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while save flows", ex);
        }
    }
}

