/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.subscription.use_case;

import io.gravitee.apim.core.TransactionalUseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.subscription.crud_service.SubscriptionCrudService;
import io.gravitee.apim.core.subscription.domain_service.CloseSubscriptionDomainService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import lombok.Generated;

@TransactionalUseCase
public class CloseSubscriptionUseCase {
    private final SubscriptionCrudService subscriptionCrudService;
    private final CloseSubscriptionDomainService closeSubscriptionDomainService;

    public CloseSubscriptionUseCase(SubscriptionCrudService subscriptionCrudService, CloseSubscriptionDomainService closeSubscriptionDomainService) {
        this.subscriptionCrudService = subscriptionCrudService;
        this.closeSubscriptionDomainService = closeSubscriptionDomainService;
    }

    public Output execute(Input input) {
        SubscriptionEntity subscription = this.subscriptionCrudService.get(input.subscriptionId);
        if (input.apiId != null && !subscription.getApiId().equals(input.apiId)) {
            throw new SubscriptionNotFoundException(input.subscriptionId);
        }
        if (input.applicationId != null && !subscription.getApplicationId().equals(input.applicationId)) {
            throw new SubscriptionNotFoundException(input.subscriptionId);
        }
        SubscriptionEntity closedSubscription = this.closeSubscriptionDomainService.closeSubscription(input.subscriptionId, input.auditInfo);
        return new Output(closedSubscription);
    }

    public record Input(String subscriptionId, String apiId, String applicationId, AuditInfo auditInfo) {
        public Input(String subscriptionId, AuditInfo auditInfo) {
            this(subscriptionId, null, null, auditInfo);
        }

        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String subscriptionId;
            @Generated
            private String apiId;
            @Generated
            private String applicationId;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder subscriptionId(String subscriptionId) {
                this.subscriptionId = subscriptionId;
                return this;
            }

            @Generated
            public InputBuilder apiId(String apiId) {
                this.apiId = apiId;
                return this;
            }

            @Generated
            public InputBuilder applicationId(String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.subscriptionId, this.apiId, this.applicationId, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "CloseSubscriptionUseCase.Input.InputBuilder(subscriptionId=" + this.subscriptionId + ", apiId=" + this.apiId + ", applicationId=" + this.applicationId + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(SubscriptionEntity subscription) {
    }
}

