/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.quality;

import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.quality.ApiQualityMetric;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiQualityMetricDescription
implements ApiQualityMetric {
    @Autowired
    ParameterService parameterService;

    @Override
    public Key getWeightKey() {
        return Key.API_QUALITY_METRICS_DESCRIPTION_WEIGHT;
    }

    @Override
    public boolean isValid(ExecutionContext executionContext, ApiEntity api) {
        int minLength = Integer.parseInt(Key.API_QUALITY_METRICS_DESCRIPTION_MIN_LENGTH.defaultValue());
        List<String> minLengthParam = this.parameterService.findAll(executionContext, Key.API_QUALITY_METRICS_DESCRIPTION_MIN_LENGTH, ParameterReferenceType.ENVIRONMENT);
        if (!minLengthParam.isEmpty()) {
            minLength = Integer.parseInt(minLengthParam.get(0));
        }
        return api.getDescription() != null && api.getDescription().length() >= minLength;
    }
}

