/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.model.ApiKey;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiKeySubscriptionsUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiKeySubscriptionsUpgrader.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiKeySubscriptionsUpgrader.class);
    private final ApiKeyRepository apiKeyRepository;

    @Autowired
    public ApiKeySubscriptionsUpgrader(@Lazy ApiKeyRepository apiKeyRepository) {
        this.apiKeyRepository = apiKeyRepository;
    }

    public int getOrder() {
        return 501;
    }

    public boolean upgrade() {
        try {
            this.apiKeyRepository.findAll().forEach(this::updateApiKeySubscriptions);
        }
        catch (Exception e) {
            log.error("error applying upgrader {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }

    private void updateApiKeySubscriptions(ApiKey apiKey) {
        try {
            List allSubscriptions;
            LOGGER.debug("Updating subscriptions for API Key [{}]", (Object)apiKey);
            List list = allSubscriptions = apiKey.getSubscriptions() != null ? apiKey.getSubscriptions() : new ArrayList();
            if (apiKey.getSubscription() != null && !allSubscriptions.contains(apiKey.getSubscription())) {
                allSubscriptions.add(apiKey.getSubscription());
            }
            apiKey.setSubscriptions(allSubscriptions);
            this.apiKeyRepository.update(apiKey);
        }
        catch (TechnicalException e) {
            LOGGER.error("Failed to update subscriptions for API Key [{}]", (Object)apiKey, (Object)e);
        }
    }
}

