/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.listener.http.Path;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.DuplicateOptions;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.MembershipDuplicateService;
import io.gravitee.rest.api.service.PageDuplicateService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.v4.ApiDuplicateService;
import io.gravitee.rest.api.service.v4.ApiService;
import io.gravitee.rest.api.service.v4.PlanService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiDuplicateServiceImpl
extends AbstractService
implements ApiDuplicateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiDuplicateServiceImpl.class);
    private final ApiService apiService;
    private final PageDuplicateService pageDuplicateService;
    private final PlanService planService;
    private final MembershipDuplicateService membershipDuplicateService;

    public ApiDuplicateServiceImpl(ApiService apiService, PageDuplicateService pageDuplicateService, PlanService planService, MembershipDuplicateService membershipDuplicateService) {
        this.apiService = apiService;
        this.pageDuplicateService = pageDuplicateService;
        this.planService = planService;
        this.membershipDuplicateService = membershipDuplicateService;
    }

    @Override
    public ApiEntity duplicate(ExecutionContext executionContext, ApiEntity sourceApi, DuplicateOptions duplicateOptions) {
        Objects.requireNonNull(sourceApi, "Missing source ApiEntity");
        String apiId = sourceApi.getId();
        log.debug("Duplicate API [apiId={}]", (Object)apiId);
        List<Listener> duplicatedListeners = sourceApi.getListeners().stream().map(l -> {
            if (l instanceof HttpListener) {
                return ((HttpListener)l).toBuilder().paths(List.of(Path.builder().path(duplicateOptions.getContextPath()).build())).build();
            }
            return l;
        }).toList();
        ApiEntity duplicateEntity = sourceApi.toBuilder().id(null).crossId(null).primaryOwner(null).apiVersion(duplicateOptions.getVersion() == null ? sourceApi.getApiVersion() : duplicateOptions.getVersion()).listeners(duplicatedListeners).groups(duplicateOptions.isGroupsFiltered() ? null : sourceApi.getGroups()).build();
        ApiEntity duplicated = this.apiService.createWithImport(executionContext, duplicateEntity, this.getAuthenticatedUsername());
        Map<String, String> duplicatedPagesIdMapping = this.duplicatePages(executionContext, sourceApi, duplicated, duplicateOptions);
        duplicated.setPlans(this.duplicatePlans(executionContext, duplicated, duplicateOptions, sourceApi.getPlans(), duplicatedPagesIdMapping));
        this.duplicateMembers(executionContext, sourceApi, duplicated, duplicateOptions);
        return duplicated;
    }

    private Map<String, String> duplicatePages(ExecutionContext executionContext, ApiEntity sourceApi, ApiEntity duplicate, DuplicateOptions duplicateOptions) {
        if (duplicateOptions.isPagesFiltered()) {
            return Map.of();
        }
        return this.pageDuplicateService.duplicatePages(executionContext, sourceApi.getId(), duplicate.getId(), this.getAuthenticatedUsername());
    }

    private Set<PlanEntity> duplicatePlans(ExecutionContext executionContext, ApiEntity duplicate, DuplicateOptions duplicateOptions, Set<PlanEntity> sourcePlans, Map<String, String> pagesIdMapping) {
        if (duplicateOptions.isPlansFiltered()) {
            return null;
        }
        Set<PlanEntity> duplicatedPlans = sourcePlans.stream().map(planEntity -> {
            planEntity.setApiId(duplicate.getId());
            planEntity.setId(UuidString.generateRandom());
            if (planEntity.getGeneralConditions() != null) {
                planEntity.setGeneralConditions((String)pagesIdMapping.get(planEntity.getGeneralConditions()));
            }
            try {
                return this.planService.createOrUpdatePlan(executionContext, (PlanEntity)planEntity);
            }
            catch (Exception e) {
                log.warn("Unable to create plan [planName={}] for duplicated API [apiId={}]' due to : {}", new Object[]{planEntity.getName(), duplicate.getId(), e.getMessage()});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        log.debug("Plans successfully duplicated for api [apiId={}]", (Object)duplicate.getId());
        return duplicatedPlans;
    }

    private void duplicateMembers(ExecutionContext executionContext, ApiEntity sourceApi, ApiEntity duplicate, DuplicateOptions duplicateOptions) {
        if (duplicateOptions.isMembersFiltered()) {
            return;
        }
        this.membershipDuplicateService.duplicateMemberships(executionContext, sourceApi.getId(), duplicate.getId(), this.getAuthenticatedUsername());
    }
}

