/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.infra.adapter.ApplicationAdapter;
import io.gravitee.definition.model.Origin;
import io.gravitee.repository.management.model.ApiKeyMode;
import io.gravitee.repository.management.model.Application;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import java.util.LinkedHashSet;
import java.util.Set;

public class ApplicationAdapterImpl
implements ApplicationAdapter {
    @Override
    public BaseApplicationEntity toEntity(Application application) {
        if (application == null) {
            return null;
        }
        BaseApplicationEntity.BaseApplicationEntityBuilder baseApplicationEntity = BaseApplicationEntity.builder();
        if (application.getOrigin() != null) {
            baseApplicationEntity.origin(application.getOrigin());
        } else {
            baseApplicationEntity.origin(Origin.MANAGEMENT);
        }
        baseApplicationEntity.id(application.getId());
        baseApplicationEntity.name(application.getName());
        baseApplicationEntity.description(application.getDescription());
        baseApplicationEntity.domain(application.getDomain());
        Set set = application.getGroups();
        if (set != null) {
            baseApplicationEntity.groups(new LinkedHashSet(set));
        }
        if (application.getStatus() != null) {
            baseApplicationEntity.status(application.getStatus().name());
        }
        if (application.getType() != null) {
            baseApplicationEntity.type(application.getType().name());
        }
        baseApplicationEntity.picture(application.getPicture());
        baseApplicationEntity.createdAt(application.getCreatedAt());
        baseApplicationEntity.updatedAt(application.getUpdatedAt());
        baseApplicationEntity.disableMembershipNotifications(application.isDisableMembershipNotifications());
        baseApplicationEntity.apiKeyMode(this.apiKeyModeToApiKeyMode(application.getApiKeyMode()));
        baseApplicationEntity.background(application.getBackground());
        return baseApplicationEntity.build();
    }

    protected io.gravitee.rest.api.model.ApiKeyMode apiKeyModeToApiKeyMode(ApiKeyMode apiKeyMode) {
        if (apiKeyMode == null) {
            return null;
        }
        return switch (apiKeyMode) {
            case ApiKeyMode.SHARED -> io.gravitee.rest.api.model.ApiKeyMode.SHARED;
            case ApiKeyMode.EXCLUSIVE -> io.gravitee.rest.api.model.ApiKeyMode.EXCLUSIVE;
            case ApiKeyMode.UNSPECIFIED -> io.gravitee.rest.api.model.ApiKeyMode.UNSPECIFIED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + apiKeyMode);
        };
    }
}

