/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.jackson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.repository.management.model.flow.FlowStep;
import java.io.IOException;

public class FlowStepSerializer
extends StdScalarSerializer<FlowStep> {
    public FlowStepSerializer(Class<FlowStep> vc) {
        super(vc);
    }

    public void serialize(FlowStep step, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("name", step.getName());
        if (step.getDescription() != null) {
            jsonGenerator.writeStringField("description", step.getDescription());
        }
        jsonGenerator.writeBooleanField("enabled", step.isEnabled());
        jsonGenerator.writeStringField("policy", step.getPolicy());
        jsonGenerator.writeNumberField("order", step.getOrder());
        if (step.getCondition() != null) {
            jsonGenerator.writeStringField("condition", step.getCondition());
        }
        jsonGenerator.writeFieldName("configuration");
        jsonGenerator.writeRawValue(step.getConfiguration());
        jsonGenerator.writeEndObject();
    }
}

