/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.organization.OrganizationCommand;
import io.gravitee.cockpit.api.command.organization.OrganizationPayload;
import io.gravitee.cockpit.api.command.organization.OrganizationReply;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UpdateOrganizationEntity;
import io.gravitee.rest.api.service.OrganizationService;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OrganizationCommandHandler
implements CommandHandler<OrganizationCommand, OrganizationReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrganizationCommandHandler.class);
    private final OrganizationService organizationService;
    private final AccessPointCrudService accessPointService;

    public Command.Type handleType() {
        return Command.Type.ORGANIZATION_COMMAND;
    }

    public Single<OrganizationReply> handle(OrganizationCommand command) {
        OrganizationPayload organizationPayload = (OrganizationPayload)command.getPayload();
        try {
            UpdateOrganizationEntity newOrganization = new UpdateOrganizationEntity();
            newOrganization.setCockpitId(organizationPayload.getCockpitId());
            newOrganization.setHrids(organizationPayload.getHrids());
            newOrganization.setName(organizationPayload.getName());
            newOrganization.setDescription(organizationPayload.getDescription());
            OrganizationEntity organization = this.organizationService.createOrUpdate(organizationPayload.getId(), newOrganization);
            List<Object> accessPointsToCreate = organizationPayload.getAccessPoints() != null ? organizationPayload.getAccessPoints().stream().map(cockpitAccessPoint -> AccessPoint.builder().referenceType(AccessPoint.ReferenceType.ORGANIZATION).referenceId(organization.getId()).target(AccessPoint.Target.valueOf(cockpitAccessPoint.getTarget().name())).host(cockpitAccessPoint.getHost()).secured(cockpitAccessPoint.isSecured()).overriding(cockpitAccessPoint.isOverriding()).build()).toList() : new ArrayList();
            this.accessPointService.updateAccessPoints(AccessPoint.ReferenceType.ORGANIZATION, organization.getId(), accessPointsToCreate);
            log.info("Organization [{}] handled with id [{}].", (Object)organization.getName(), (Object)organization.getId());
            return Single.just((Object)new OrganizationReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception e) {
            log.error("Error occurred when handling organization [{}] with id [{}].", new Object[]{organizationPayload.getName(), organizationPayload.getId(), e});
            return Single.just((Object)new OrganizationReply(command.getId(), CommandStatus.ERROR));
        }
    }

    @Generated
    public OrganizationCommandHandler(OrganizationService organizationService, AccessPointCrudService accessPointService) {
        this.organizationService = organizationService;
        this.accessPointService = accessPointService;
    }
}

