/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.access_point;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.apim.core.access_point.model.AccessPointEvent;
import io.gravitee.apim.infra.adapter.AccessPointAdapter;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AccessPointRepository;
import io.gravitee.repository.management.model.AccessPoint;
import io.gravitee.repository.management.model.AccessPointReferenceType;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AccessPointCrudServiceImpl
extends TransactionalService
implements AccessPointCrudService {
    private final AccessPointRepository accessPointRepository;
    private EventManager eventManager;

    public AccessPointCrudServiceImpl(@Lazy AccessPointRepository accessPointRepository, EventManager eventManager) {
        this.accessPointRepository = accessPointRepository;
        this.eventManager = eventManager;
    }

    @Override
    public void updateAccessPoints(AccessPoint.ReferenceType referenceType, String referenceId, List<io.gravitee.apim.core.access_point.model.AccessPoint> accessPoints) {
        try {
            List deleteAccessPoints = this.accessPointRepository.deleteByReference(AccessPointReferenceType.valueOf((String)referenceType.name()), referenceId);
            if (deleteAccessPoints != null) {
                deleteAccessPoints.stream().map(AccessPointAdapter.INSTANCE::toEntity).forEach(accessPoint -> this.eventManager.publishEvent((Enum)AccessPointEvent.DELETED, accessPoint));
            }
            for (io.gravitee.apim.core.access_point.model.AccessPoint accessPoint2 : accessPoints) {
                AccessPoint ap = AccessPointAdapter.INSTANCE.fromEntity(accessPoint2);
                if (ap.getId() == null) {
                    ap.setId(UuidString.generateRandom());
                }
                AccessPoint createdAccessPoint = (AccessPoint)this.accessPointRepository.create((Object)ap);
                this.eventManager.publishEvent((Enum)AccessPointEvent.CREATED, (Object)AccessPointAdapter.INSTANCE.toEntity(createdAccessPoint));
            }
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while creating access points", e);
        }
    }
}

