/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginDocumentation;
import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.rest.api.model.platform.plugin.SchemaDisplayFormat;
import io.gravitee.rest.api.model.v4.policy.ApiProtocolType;
import io.gravitee.rest.api.model.v4.policy.FlowPhase;
import io.gravitee.rest.api.model.v4.policy.PolicyPluginEntity;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import io.gravitee.rest.api.service.v4.PolicyPluginService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PolicyPluginServiceImpl
extends AbstractPluginService<PolicyPlugin<?>, PolicyPluginEntity>
implements PolicyPluginService {
    public static final Set<String> INTERNAL_POLICIES_ID = Set.of("shared-policy-group-policy");

    protected PolicyPluginServiceImpl(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<PolicyPlugin<?>> policyManager) {
        super(jsonSchemaService, policyManager);
    }

    @Override
    public Set<PolicyPluginEntity> findAll() {
        return super.list().stream().map(this::convert).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public PolicyPluginEntity findById(String policyPluginId) {
        PolicyPlugin resourceDefinition = (PolicyPlugin)super.get(policyPluginId);
        return this.convert((Plugin)resourceDefinition);
    }

    protected PolicyPluginEntity convert(Plugin plugin) {
        PolicyPluginEntity entity = new PolicyPluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setIcon(this.getIcon(plugin.id()));
        entity.setVersion(plugin.manifest().version());
        entity.setCategory(plugin.manifest().category());
        entity.setDeployed(plugin.deployed());
        Set<FlowPhase> httpProxyFlowPhase = PolicyPluginServiceImpl.getFlowPhase(plugin, ApiProtocolType.HTTP_PROXY);
        Set<FlowPhase> httpMessageFlowPhase = PolicyPluginServiceImpl.getFlowPhase(plugin, ApiProtocolType.HTTP_MESSAGE);
        Set<FlowPhase> nativeKafkaFlowPhase = PolicyPluginServiceImpl.getFlowPhase(plugin, ApiProtocolType.NATIVE_KAFKA);
        Set<FlowPhase> mcpProxyFlowPhase = PolicyPluginServiceImpl.getFlowPhase(plugin, ApiProtocolType.MCP_PROXY);
        Set<FlowPhase> llmProxyFlowPhase = PolicyPluginServiceImpl.getFlowPhase(plugin, ApiProtocolType.LLM_PROXY);
        if (httpProxyFlowPhase.isEmpty()) {
            httpProxyFlowPhase = PolicyPluginServiceImpl.getDeprecatedFlowPhase(plugin, "proxy");
        }
        if (httpMessageFlowPhase.isEmpty()) {
            httpMessageFlowPhase = PolicyPluginServiceImpl.getDeprecatedFlowPhase(plugin, "message");
        }
        entity.putFlowPhaseCompatibility(ApiProtocolType.HTTP_PROXY, httpProxyFlowPhase);
        entity.putFlowPhaseCompatibility(ApiProtocolType.HTTP_MESSAGE, httpMessageFlowPhase);
        entity.putFlowPhaseCompatibility(ApiProtocolType.NATIVE_KAFKA, nativeKafkaFlowPhase);
        entity.putFlowPhaseCompatibility(ApiProtocolType.MCP_PROXY, mcpProxyFlowPhase);
        entity.putFlowPhaseCompatibility(ApiProtocolType.LLM_PROXY, llmProxyFlowPhase);
        return entity;
    }

    @Override
    public String validatePolicyConfiguration(String policyPluginId, String configuration) {
        if (INTERNAL_POLICIES_ID.contains(policyPluginId)) {
            return configuration;
        }
        PolicyPluginEntity policyPluginEntity = this.findById(policyPluginId);
        return this.validateConfiguration(policyPluginEntity.getId(), configuration);
    }

    @Override
    public String validatePolicyConfiguration(PolicyPluginEntity policyPluginEntity, String configuration) {
        return this.validateConfiguration(policyPluginEntity.getId(), configuration);
    }

    @Override
    public String getSchema(String policyPluginId, ApiProtocolType apiProtocolType, SchemaDisplayFormat schemaDisplayFormat) {
        ArrayList<Object> schemaKeys = new ArrayList<Object>();
        if (apiProtocolType != null && schemaDisplayFormat != null) {
            schemaKeys.add(apiProtocolType.name().toLowerCase() + ".schema." + schemaDisplayFormat.name().toLowerCase());
        }
        if (apiProtocolType != null) {
            schemaKeys.add(apiProtocolType.name().toLowerCase() + ".schema");
        }
        if (schemaDisplayFormat != null) {
            schemaKeys.add("schema." + schemaDisplayFormat.name().toLowerCase());
        }
        schemaKeys.add("schema");
        for (String string : schemaKeys) {
            try {
                this.logger.debug("Find plugin schema for format {} by ID: {}", (Object)schemaDisplayFormat, (Object)policyPluginId);
                String schema = this.pluginManager.getSchema(policyPluginId, string, false, true);
                if (schema == null) continue;
                return schema;
            }
            catch (IOException ioex) {
                this.logger.debug("Error while getting specific schema for this display format. Fall back on default schema.");
            }
        }
        this.logger.debug("No specific schema exists for this display format. Fall back on default schema.");
        return this.getSchema(policyPluginId);
    }

    @Override
    public PluginDocumentation getDocumentation(String policyPluginId, ApiProtocolType apiProtocolType) {
        try {
            if (apiProtocolType != null) {
                return this.pluginManager.getPluginDocumentation(policyPluginId, apiProtocolType.name().toLowerCase() + ".documentation", true, true);
            }
            return this.pluginManager.getPluginDocumentation(policyPluginId);
        }
        catch (IOException ioex) {
            throw new TechnicalManagementException("An error occurs while trying to get plugin documentation for plugin " + policyPluginId, ioex);
        }
    }

    private static Set<FlowPhase> getDeprecatedFlowPhase(Plugin plugin, String property) {
        if (plugin.manifest().properties() != null && plugin.manifest().properties().get(property) != null && !((String)plugin.manifest().properties().get(property)).isEmpty()) {
            return Arrays.stream(((String)plugin.manifest().properties().get(property)).split(",")).map(String::trim).map(POLICY_FLOW_PHASE::valueOf).map(p -> switch (p.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> FlowPhase.INTERACT;
                case 1 -> FlowPhase.CONNECT;
                case 2, 6 -> FlowPhase.PUBLISH;
                case 3, 7 -> FlowPhase.SUBSCRIBE;
                case 4 -> FlowPhase.REQUEST;
                case 5 -> FlowPhase.RESPONSE;
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static Set<FlowPhase> getFlowPhase(Plugin plugin, ApiProtocolType apiProtocolType) {
        if (plugin.manifest().properties() == null) {
            return null;
        }
        String apiProtocolTypeProperty = (String)plugin.manifest().properties().get(apiProtocolType.name().toLowerCase());
        if (apiProtocolTypeProperty != null) {
            return Arrays.stream(apiProtocolTypeProperty.split(",")).map(String::trim).map(FlowPhase::valueOf).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static enum POLICY_FLOW_PHASE {
        INTERACT,
        CONNECT,
        PUBLISH,
        SUBSCRIBE,
        REQUEST,
        RESPONSE,
        MESSAGE_REQUEST,
        MESSAGE_RESPONSE;

    }
}

