/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalPageContextRepository;
import io.gravitee.repository.management.api.PortalPageRepository;
import io.gravitee.repository.management.model.PortalPage;
import io.gravitee.repository.management.model.PortalPageContext;
import io.gravitee.repository.management.model.PortalPageContextType;
import io.gravitee.rest.api.service.PortalPageService;
import io.gravitee.rest.api.service.common.UuidString;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class PortalPageServiceImpl
implements PortalPageService {
    private static final String DEFAULT_PORTAL_PAGE_NAME = "Default Portal Page";
    private String defaultPortalPageContent;
    private final PortalPageRepository portalPageRepository;
    private final PortalPageContextRepository portalPageContextRepository;

    public PortalPageServiceImpl(@Lazy PortalPageRepository portalPageRepository, @Lazy PortalPageContextRepository portalPageContextRepository) {
        this.portalPageRepository = portalPageRepository;
        this.portalPageContextRepository = portalPageContextRepository;
    }

    @Override
    public void createDefaultPortalHomePage(String environmentId) throws TechnicalException {
        Date now = new Date();
        List homePages = this.portalPageContextRepository.findAllByContextTypeAndEnvironmentId(PortalPageContextType.HOMEPAGE, environmentId);
        if (homePages.isEmpty()) {
            PortalPage createPortalPage = (PortalPage)this.portalPageRepository.create((Object)PortalPage.builder().id(UuidString.generateRandom()).environmentId(environmentId).name(DEFAULT_PORTAL_PAGE_NAME).content(this.getDefaultPortalPageContent()).createdAt(now).updatedAt(now).build());
            this.portalPageContextRepository.create((Object)PortalPageContext.builder().id(UuidString.generateRandom()).pageId(createPortalPage.getId()).contextType(PortalPageContextType.HOMEPAGE).environmentId(environmentId).published(true).build());
        }
    }

    private String getDefaultPortalPageContent() {
        if (this.defaultPortalPageContent == null) {
            try {
                ClassPathResource resource = new ClassPathResource("templates/default-portal-homepage-content.md");
                this.defaultPortalPageContent = new String(resource.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not load default portal page template", e);
            }
        }
        return this.defaultPortalPageContent;
    }
}

