/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.template;

import freemarker.ext.beans.ClassMemberAccessPolicy;
import freemarker.ext.beans.MemberAccessPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Set;

public final class SecureMemberAccessPolicy
implements MemberAccessPolicy {
    public ClassMemberAccessPolicy forClass(Class<?> clazz) {
        return new SecureClassPolicy();
    }

    public boolean isToStringAlwaysExposed() {
        return true;
    }

    private static final class SecureClassPolicy
    implements ClassMemberAccessPolicy {
        private static final Set<String> FORBIDDEN_METHODS = Set.of("getClass", "getClassLoader", "getContextClassLoader", "getProtectionDomain", "forName", "newInstance");
        private static final Set<Class<?>> FORBIDDEN_TYPES = Set.of(Class.class, ClassLoader.class, ProtectionDomain.class, Thread.class, Member.class);

        private SecureClassPolicy() {
        }

        public boolean isMethodExposed(Method method) {
            if (method.getDeclaringClass() == Object.class) {
                return "equals".equals(method.getName()) || "hashCode".equals(method.getName());
            }
            if (FORBIDDEN_METHODS.contains(method.getName())) {
                return false;
            }
            Class<?> returnType = method.getReturnType();
            return FORBIDDEN_TYPES.stream().noneMatch(type -> type.isAssignableFrom(returnType));
        }

        public boolean isConstructorExposed(Constructor<?> constructor) {
            return false;
        }

        public boolean isFieldExposed(Field field) {
            return false;
        }
    }
}

