/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.portal_page;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.portal_page.model.PortalArea;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemQueryCriteria;
import io.gravitee.apim.core.portal_page.query_service.PortalNavigationItemsQueryService;
import io.gravitee.apim.infra.adapter.PortalNavigationItemAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalNavigationItemRepository;
import io.gravitee.repository.management.api.search.PortalNavigationItemCriteria;
import io.gravitee.repository.management.model.PortalNavigationItem;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PortalNavigationItemsQueryServiceImpl
implements PortalNavigationItemsQueryService {
    private final PortalNavigationItemRepository portalNavigationItemRepository;
    private final PortalNavigationItemAdapter portalNavigationItemAdapter = PortalNavigationItemAdapter.INSTANCE;

    public PortalNavigationItemsQueryServiceImpl(@Lazy PortalNavigationItemRepository portalNavigationItemRepository) {
        this.portalNavigationItemRepository = portalNavigationItemRepository;
    }

    @Override
    public PortalNavigationItem findByIdAndEnvironmentId(String environmentId, PortalNavigationItemId id) {
        try {
            Optional result = this.portalNavigationItemRepository.findById((Object)id.json());
            if (result.isPresent() && ((io.gravitee.repository.management.model.PortalNavigationItem)result.get()).getEnvironmentId().equals(environmentId)) {
                return this.portalNavigationItemAdapter.toEntity((io.gravitee.repository.management.model.PortalNavigationItem)result.get());
            }
            return null;
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while finding portal navigation item by id %s and environmentId %s", id, environmentId);
            throw new TechnicalDomainException(errorMessage, e);
        }
    }

    @Override
    public List<PortalNavigationItem> findByParentIdAndEnvironmentId(String environmentId, PortalNavigationItemId parentId) {
        try {
            String cleanedParentId = Optional.ofNullable(parentId).map(PortalNavigationItemId::json).orElse(null);
            List results = this.portalNavigationItemRepository.findAllByParentIdAndEnvironmentId(cleanedParentId, environmentId);
            return results.stream().map(this.portalNavigationItemAdapter::toEntity).collect(Collectors.toList());
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while finding portal navigation items by parentId %s and environmentId %s", parentId, environmentId);
            throw new TechnicalDomainException(errorMessage, e);
        }
    }

    @Override
    public List<PortalNavigationItem> search(PortalNavigationItemQueryCriteria criteria) {
        try {
            PortalNavigationItemCriteria repoCriteria = this.portalNavigationItemAdapter.map(criteria);
            List results = this.portalNavigationItemRepository.searchByCriteria(repoCriteria);
            return results.stream().map(this.portalNavigationItemAdapter::toEntity).collect(Collectors.toList());
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while searching portal navigation items by criteria %s", criteria.toString());
            throw new TechnicalDomainException(errorMessage, e);
        }
    }

    @Override
    public List<PortalNavigationItem> findTopLevelItemsByEnvironmentIdAndPortalArea(String environmentId, PortalArea portalArea) {
        try {
            PortalNavigationItem.Area area = switch (portalArea) {
                default -> throw new MatchException(null, null);
                case PortalArea.HOMEPAGE -> PortalNavigationItem.Area.HOMEPAGE;
                case PortalArea.TOP_NAVBAR -> PortalNavigationItem.Area.TOP_NAVBAR;
            };
            List results = this.portalNavigationItemRepository.findAllByAreaAndEnvironmentIdAndParentIdIsNull(area, environmentId);
            return results.stream().map(this.portalNavigationItemAdapter::toEntity).collect(Collectors.toList());
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while finding top level portal navigation items by environmentId %s and area %s", new Object[]{environmentId, portalArea});
            throw new TechnicalDomainException(errorMessage, e);
        }
    }
}

