/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.analytics_engine;

import io.gravitee.apim.core.analytics_engine.model.FacetsRequest;
import io.gravitee.apim.core.analytics_engine.model.FacetsResponse;
import io.gravitee.apim.core.analytics_engine.model.MeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.MeasuresResponse;
import io.gravitee.apim.core.analytics_engine.model.MetricSpec;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesRequest;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesResponse;
import io.gravitee.apim.core.analytics_engine.query_service.AnalyticsEngineQueryService;
import io.gravitee.apim.infra.adapter.AnalyticsMeasuresAdapter;
import io.gravitee.repository.analytics.engine.api.query.MeasuresQuery;
import io.gravitee.repository.analytics.engine.api.result.MeasuresResult;
import io.gravitee.repository.log.v4.api.AnalyticsRepository;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Set;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MessageDataPlaneQueryService
implements AnalyticsEngineQueryService {
    private final AnalyticsRepository analyticsRepository;

    public MessageDataPlaneQueryService(@Lazy AnalyticsRepository analyticsRepository) {
        this.analyticsRepository = analyticsRepository;
    }

    @Override
    public Set<MetricSpec.Name> metrics() {
        return Set.of(MetricSpec.Name.MESSAGE_PAYLOAD_SIZE, MetricSpec.Name.MESSAGE_ERRORS, MetricSpec.Name.MESSAGES, MetricSpec.Name.MESSAGE_GATEWAY_LATENCY);
    }

    @Override
    public MeasuresResponse searchMeasures(ExecutionContext context, MeasuresRequest request) {
        MeasuresQuery query = AnalyticsMeasuresAdapter.INSTANCE.fromRequest(request);
        MeasuresResult result = this.analyticsRepository.searchMessageMeasures(context.getQueryContext(), query);
        return AnalyticsMeasuresAdapter.INSTANCE.fromResult(result);
    }

    @Override
    public FacetsResponse searchFacets(ExecutionContext context, FacetsRequest request) {
        throw new UnsupportedOperationException("Facets are not supported for message analytics");
    }

    @Override
    public TimeSeriesResponse searchTimeSeries(ExecutionContext context, TimeSeriesRequest request) {
        throw new UnsupportedOperationException("Time series are not supported for message analytics");
    }
}

