/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.analytics_engine.processors;

import io.gravitee.apim.core.analytics_engine.domain_service.FilterPreProcessor;
import io.gravitee.apim.core.analytics_engine.model.Filter;
import io.gravitee.apim.core.analytics_engine.model.FilterSpec;
import io.gravitee.apim.core.analytics_engine.model.MetricsContext;
import io.gravitee.rest.api.model.Identifiable;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.search.query.QueryBuilder;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class ManagementFilterPreProcessor
implements FilterPreProcessor {
    private static final String ORGANIZATION_ADMIN = RoleScope.ORGANIZATION.name() + ":" + SystemRole.ADMIN.name();
    private final ApiSearchService apiSearchService;

    @Override
    public MetricsContext buildFilters(MetricsContext context) {
        Map<String, String> userApis = this.findUserApis();
        Set<String> userApisIds = userApis.keySet();
        Filter permissionsFilter = new Filter(FilterSpec.Name.API, FilterSpec.Operator.IN, userApisIds);
        return context.withFilters(List.of(permissionsFilter)).withApiNamesById(userApis);
    }

    private static Map<String, String> mapApiIdsToNames(Collection<GenericApiEntity> apis) {
        return apis.stream().collect(Collectors.toMap(Identifiable::getId, GenericApiEntity::getName));
    }

    protected boolean isAdmin() {
        return this.isUserInRole(ORGANIZATION_ADMIN);
    }

    protected boolean isUserInRole(String role) {
        return SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().anyMatch(grantedAuthority -> {
            String authority = grantedAuthority.getAuthority();
            return authority.equalsIgnoreCase(role);
        });
    }

    protected Principal getUserPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication instanceof AnonymousAuthenticationToken ? null : authentication;
    }

    private Map<String, String> findUserApis() {
        QueryBuilder<ApiEntity> queryBuilder = QueryBuilder.create(ApiEntity.class);
        boolean admin = this.isAdmin();
        Principal userPrincipal = this.getUserPrincipal();
        String userName = userPrincipal.getName();
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        List content = this.apiSearchService.search(executionContext, userName, admin, queryBuilder, (Pageable)new PageableImpl(0, Integer.MAX_VALUE), false, true).getContent();
        return ManagementFilterPreProcessor.mapApiIdsToNames(content);
    }

    @Generated
    public ManagementFilterPreProcessor(ApiSearchService apiSearchService) {
        this.apiSearchService = apiSearchService;
    }
}

