/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.analytics_engine.definition;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.gravitee.apim.core.analytics_engine.model.AnalyticsDefinition;
import io.gravitee.apim.core.analytics_engine.model.AnalyticsDefinitionSpec;
import io.gravitee.apim.core.analytics_engine.model.ApiSpec;
import io.gravitee.apim.core.analytics_engine.model.FacetSpec;
import io.gravitee.apim.core.analytics_engine.model.FilterSpec;
import io.gravitee.apim.core.analytics_engine.model.MetricSpec;
import io.gravitee.apim.core.analytics_engine.query_service.AnalyticsDefinitionQueryService;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class AnalyticsDefinitionYAMLQueryService
implements AnalyticsDefinitionQueryService {
    private static final String ANALYTICS_DEFINITION_FILE = "analytics/definition/analytics-definition.yaml";
    private static final YAMLMapper YAML = new YAMLMapper();
    private final AnalyticsDefinitionSpec spec = AnalyticsDefinitionYAMLQueryService.readYAMLDefinition().spec();

    private static AnalyticsDefinition readYAMLDefinition() {
        try {
            return (AnalyticsDefinition)YAML.readValue(AnalyticsDefinitionYAMLQueryService.class.getClassLoader().getResourceAsStream(ANALYTICS_DEFINITION_FILE), AnalyticsDefinition.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read analytics definition file", e);
        }
    }

    @Override
    public List<ApiSpec> getApis() {
        return this.spec.apis();
    }

    @Override
    public List<MetricSpec> getMetrics(ApiSpec.Name apiSpecName) {
        return this.spec.metrics().stream().filter(metric -> metric.apis().contains((Object)apiSpecName)).toList();
    }

    @Override
    public List<FilterSpec> getFilters(MetricSpec.Name metricSpecName) {
        MetricSpec metric = this.getMetricByName(metricSpecName);
        return this.spec.filters().stream().filter(filter -> metric.filters().contains((Object)filter.name())).toList();
    }

    @Override
    public List<FacetSpec> getFacets(MetricSpec.Name metricSpecName) {
        MetricSpec metric = this.getMetricByName(metricSpecName);
        return this.spec.facets().stream().filter(facet -> metric.facets().contains((Object)facet.name())).toList();
    }

    @Override
    public Optional<MetricSpec> findMetric(MetricSpec.Name metricName) {
        return this.spec.metrics().stream().filter(metric -> metric.name().equals((Object)metricName)).findFirst();
    }

    private MetricSpec getMetricByName(MetricSpec.Name metricSpecName) {
        return this.spec.metrics().stream().filter(metric -> metric.name().equals((Object)metricSpecName)).findFirst().orElse(null);
    }
}

