/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.portal_page;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.portal_page.crud_service.PortalPageContentCrudService;
import io.gravitee.apim.core.portal_page.model.GraviteeMarkdownPageContent;
import io.gravitee.apim.core.portal_page.model.PortalPageContent;
import io.gravitee.apim.core.portal_page.model.PortalPageContentId;
import io.gravitee.apim.infra.adapter.PortalPageContentAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalPageContentRepository;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class PortalPageContentCrudServiceImpl
implements PortalPageContentCrudService {
    private String defaultPortalPageContent;
    private final PortalPageContentRepository portalPageContentRepository;
    private final PortalPageContentAdapter portalPageContentAdapter = PortalPageContentAdapter.INSTANCE;

    public PortalPageContentCrudServiceImpl(@Lazy PortalPageContentRepository portalPageContentRepository) {
        this.portalPageContentRepository = portalPageContentRepository;
    }

    @Override
    public PortalPageContent create(PortalPageContent content) {
        try {
            io.gravitee.repository.management.model.PortalPageContent repoContent = this.portalPageContentAdapter.toRepository(content);
            io.gravitee.repository.management.model.PortalPageContent createdContent = (io.gravitee.repository.management.model.PortalPageContent)this.portalPageContentRepository.create((Object)repoContent);
            return this.portalPageContentAdapter.toEntity(createdContent);
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while creating portal page content with id %s", content.getId());
            throw new TechnicalDomainException(errorMessage, e);
        }
    }

    @Override
    public PortalPageContent createDefault(String organizationId, String environmentId) {
        PortalPageContentId pageContentId = PortalPageContentId.random();
        GraviteeMarkdownPageContent portalPageContent = new GraviteeMarkdownPageContent(pageContentId, organizationId, environmentId, this.getDefaultPortalPageContent());
        return this.create(portalPageContent);
    }

    @Override
    public PortalPageContent update(PortalPageContent content) {
        try {
            io.gravitee.repository.management.model.PortalPageContent repoContent = this.portalPageContentAdapter.toRepository(content);
            io.gravitee.repository.management.model.PortalPageContent updatedContent = (io.gravitee.repository.management.model.PortalPageContent)this.portalPageContentRepository.update((Object)repoContent);
            return this.portalPageContentAdapter.toEntity(updatedContent);
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while updating portal page content with id %s", content.getId());
            throw new TechnicalDomainException(errorMessage, e);
        }
    }

    @Override
    public void delete(PortalPageContentId id) {
        try {
            this.portalPageContentRepository.delete((Object)id.json());
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while deleting portal page content with id %s", id);
            throw new TechnicalDomainException(errorMessage, e);
        }
    }

    private String getDefaultPortalPageContent() {
        if (this.defaultPortalPageContent == null) {
            try {
                ClassPathResource resource = new ClassPathResource("templates/default-portal-page-content.md");
                this.defaultPortalPageContent = resource.getContentAsString(StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not load default portal page template", e);
            }
        }
        return this.defaultPortalPageContent;
    }
}

