/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.portal_page;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.portal_page.crud_service.PortalNavigationItemCrudService;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.infra.adapter.PortalNavigationItemAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalNavigationItemRepository;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PortalNavigationItemsCrudServiceImpl
implements PortalNavigationItemCrudService {
    private final PortalNavigationItemRepository portalNavigationItemRepository;
    private final PortalNavigationItemAdapter portalNavigationItemAdapter = PortalNavigationItemAdapter.INSTANCE;

    public PortalNavigationItemsCrudServiceImpl(@Lazy PortalNavigationItemRepository portalNavigationItemRepository) {
        this.portalNavigationItemRepository = portalNavigationItemRepository;
    }

    @Override
    public PortalNavigationItem create(PortalNavigationItem portalNavigationItem) {
        try {
            io.gravitee.repository.management.model.PortalNavigationItem repoItem = this.portalNavigationItemAdapter.toRepository(portalNavigationItem);
            io.gravitee.repository.management.model.PortalNavigationItem createdItem = (io.gravitee.repository.management.model.PortalNavigationItem)this.portalNavigationItemRepository.create((Object)repoItem);
            return this.portalNavigationItemAdapter.toEntity(createdItem);
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while creating portal navigation item with id %s and environmentId %s", portalNavigationItem.getId(), portalNavigationItem.getEnvironmentId());
            throw new TechnicalDomainException(errorMessage, e);
        }
    }

    @Override
    public PortalNavigationItem update(PortalNavigationItem portalNavigationItem) {
        try {
            io.gravitee.repository.management.model.PortalNavigationItem repoItem = this.portalNavigationItemAdapter.toRepository(portalNavigationItem);
            io.gravitee.repository.management.model.PortalNavigationItem updatedItem = (io.gravitee.repository.management.model.PortalNavigationItem)this.portalNavigationItemRepository.update((Object)repoItem);
            return this.portalNavigationItemAdapter.toEntity(updatedItem);
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while updating portal navigation item with id %s and environmentId %s", portalNavigationItem.getId(), portalNavigationItem.getEnvironmentId());
            throw new TechnicalDomainException(errorMessage, e);
        }
    }

    @Override
    public void delete(PortalNavigationItemId portalNavigationItemId) {
        try {
            this.portalNavigationItemRepository.delete((Object)portalNavigationItemId.toString());
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while deleting portal navigation item with id %s", portalNavigationItemId);
            throw new TechnicalDomainException(errorMessage, e);
        }
    }
}

