/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.promotion.model.Promotion;
import io.gravitee.apim.core.promotion.model.PromotionAuthor;
import io.gravitee.apim.core.promotion.model.PromotionRequest;
import io.gravitee.apim.infra.adapter.PromotionAdapter;
import io.gravitee.repository.management.model.Promotion;
import io.gravitee.repository.management.model.PromotionStatus;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntityAuthor;
import io.gravitee.rest.api.model.promotion.PromotionEntityStatus;
import io.gravitee.rest.api.model.promotion.PromotionRequestEntity;
import java.util.Date;

public class PromotionAdapterImpl
implements PromotionAdapter {
    @Override
    public io.gravitee.apim.core.promotion.model.Promotion toCoreModel(Promotion promotion) {
        if (promotion == null) {
            return null;
        }
        Promotion.PromotionBuilder promotion1 = io.gravitee.apim.core.promotion.model.Promotion.builder();
        promotion1.id(promotion.getId());
        promotion1.apiDefinition(promotion.getApiDefinition());
        promotion1.apiId(promotion.getApiId());
        promotion1.status(this.promotionStatusToPromotionStatus(promotion.getStatus()));
        promotion1.targetEnvCockpitId(promotion.getTargetEnvCockpitId());
        promotion1.targetEnvName(promotion.getTargetEnvName());
        promotion1.sourceEnvCockpitId(promotion.getSourceEnvCockpitId());
        promotion1.sourceEnvName(promotion.getSourceEnvName());
        if (promotion.getCreatedAt() != null) {
            promotion1.createdAt(promotion.getCreatedAt().toInstant());
        }
        if (promotion.getUpdatedAt() != null) {
            promotion1.updatedAt(promotion.getUpdatedAt().toInstant());
        }
        promotion1.author(this.toCoreModel(promotion.getAuthor()));
        promotion1.targetApiId(promotion.getTargetApiId());
        return promotion1.build();
    }

    @Override
    public PromotionAuthor toCoreModel(io.gravitee.repository.management.model.PromotionAuthor promotionAuthor) {
        if (promotionAuthor == null) {
            return null;
        }
        PromotionAuthor.PromotionAuthorBuilder promotionAuthor1 = PromotionAuthor.builder();
        promotionAuthor1.userId(promotionAuthor.getUserId());
        promotionAuthor1.displayName(promotionAuthor.getDisplayName());
        promotionAuthor1.email(promotionAuthor.getEmail());
        promotionAuthor1.source(promotionAuthor.getSource());
        promotionAuthor1.sourceId(promotionAuthor.getSourceId());
        return promotionAuthor1.build();
    }

    @Override
    public io.gravitee.apim.core.promotion.model.Promotion toCoreModel(PromotionEntity promotionEntity) {
        if (promotionEntity == null) {
            return null;
        }
        Promotion.PromotionBuilder promotion = io.gravitee.apim.core.promotion.model.Promotion.builder();
        promotion.id(promotionEntity.getId());
        promotion.apiDefinition(promotionEntity.getApiDefinition());
        promotion.apiId(promotionEntity.getApiId());
        promotion.status(this.promotionEntityStatusToPromotionStatus(promotionEntity.getStatus()));
        promotion.targetEnvCockpitId(promotionEntity.getTargetEnvCockpitId());
        promotion.targetEnvName(promotionEntity.getTargetEnvName());
        promotion.sourceEnvCockpitId(promotionEntity.getSourceEnvCockpitId());
        promotion.sourceEnvName(promotionEntity.getSourceEnvName());
        if (promotionEntity.getCreatedAt() != null) {
            promotion.createdAt(promotionEntity.getCreatedAt().toInstant());
        }
        if (promotionEntity.getUpdatedAt() != null) {
            promotion.updatedAt(promotionEntity.getUpdatedAt().toInstant());
        }
        promotion.author(this.toCoreModel(promotionEntity.getAuthor()));
        promotion.targetApiId(promotionEntity.getTargetApiId());
        return promotion.build();
    }

    @Override
    public PromotionAuthor toCoreModel(PromotionEntityAuthor promotionEntityAuthor) {
        if (promotionEntityAuthor == null) {
            return null;
        }
        PromotionAuthor.PromotionAuthorBuilder promotionAuthor = PromotionAuthor.builder();
        promotionAuthor.userId(promotionEntityAuthor.getUserId());
        promotionAuthor.displayName(promotionEntityAuthor.getDisplayName());
        promotionAuthor.email(promotionEntityAuthor.getEmail());
        promotionAuthor.source(promotionEntityAuthor.getSource());
        promotionAuthor.sourceId(promotionEntityAuthor.getSourceId());
        return promotionAuthor.build();
    }

    @Override
    public Promotion toRepository(io.gravitee.apim.core.promotion.model.Promotion promotion) {
        if (promotion == null) {
            return null;
        }
        Promotion promotion1 = new Promotion();
        promotion1.setId(promotion.getId());
        promotion1.setTargetEnvCockpitId(promotion.getTargetEnvCockpitId());
        promotion1.setSourceEnvCockpitId(promotion.getSourceEnvCockpitId());
        if (promotion.getCreatedAt() != null) {
            promotion1.setCreatedAt(Date.from(promotion.getCreatedAt()));
        }
        if (promotion.getUpdatedAt() != null) {
            promotion1.setUpdatedAt(Date.from(promotion.getUpdatedAt()));
        }
        promotion1.setApiDefinition(promotion.getApiDefinition());
        promotion1.setStatus(this.promotionStatusToPromotionStatus1(promotion.getStatus()));
        promotion1.setApiId(promotion.getApiId());
        promotion1.setTargetEnvName(promotion.getTargetEnvName());
        promotion1.setSourceEnvName(promotion.getSourceEnvName());
        promotion1.setAuthor(this.toRepository(promotion.getAuthor()));
        promotion1.setTargetApiId(promotion.getTargetApiId());
        return promotion1;
    }

    @Override
    public io.gravitee.repository.management.model.PromotionAuthor toRepository(PromotionAuthor promotionAuthor) {
        if (promotionAuthor == null) {
            return null;
        }
        io.gravitee.repository.management.model.PromotionAuthor promotionAuthor1 = new io.gravitee.repository.management.model.PromotionAuthor();
        promotionAuthor1.setUserId(promotionAuthor.getUserId());
        promotionAuthor1.setDisplayName(promotionAuthor.getDisplayName());
        promotionAuthor1.setEmail(promotionAuthor.getEmail());
        promotionAuthor1.setSource(promotionAuthor.getSource());
        promotionAuthor1.setSourceId(promotionAuthor.getSourceId());
        return promotionAuthor1;
    }

    @Override
    public PromotionEntity toRestApiModel(io.gravitee.apim.core.promotion.model.Promotion promotion) {
        if (promotion == null) {
            return null;
        }
        PromotionEntity promotionEntity = new PromotionEntity();
        promotionEntity.setTargetEnvCockpitId(promotion.getTargetEnvCockpitId());
        promotionEntity.setSourceEnvCockpitId(promotion.getSourceEnvCockpitId());
        if (promotion.getCreatedAt() != null) {
            promotionEntity.setCreatedAt(Date.from(promotion.getCreatedAt()));
        }
        if (promotion.getUpdatedAt() != null) {
            promotionEntity.setUpdatedAt(Date.from(promotion.getUpdatedAt()));
        }
        promotionEntity.setStatus(this.toRestApiModel(promotion.getStatus()));
        promotionEntity.setApiDefinition(promotion.getApiDefinition());
        promotionEntity.setId(promotion.getId());
        promotionEntity.setApiId(promotion.getApiId());
        promotionEntity.setTargetEnvName(promotion.getTargetEnvName());
        promotionEntity.setSourceEnvName(promotion.getSourceEnvName());
        promotionEntity.setAuthor(this.toRestApiModel(promotion.getAuthor()));
        promotionEntity.setTargetApiId(promotion.getTargetApiId());
        return promotionEntity;
    }

    @Override
    public PromotionEntityAuthor toRestApiModel(PromotionAuthor promotionAuthor) {
        if (promotionAuthor == null) {
            return null;
        }
        PromotionEntityAuthor promotionEntityAuthor = new PromotionEntityAuthor();
        promotionEntityAuthor.setUserId(promotionAuthor.getUserId());
        promotionEntityAuthor.setDisplayName(promotionAuthor.getDisplayName());
        promotionEntityAuthor.setEmail(promotionAuthor.getEmail());
        promotionEntityAuthor.setSource(promotionAuthor.getSource());
        promotionEntityAuthor.setSourceId(promotionAuthor.getSourceId());
        return promotionEntityAuthor;
    }

    @Override
    public PromotionEntityStatus toRestApiModel(io.gravitee.apim.core.promotion.model.PromotionStatus promotionStatus) {
        if (promotionStatus == null) {
            return null;
        }
        return switch (promotionStatus) {
            case io.gravitee.apim.core.promotion.model.PromotionStatus.CREATED -> PromotionEntityStatus.CREATED;
            case io.gravitee.apim.core.promotion.model.PromotionStatus.TO_BE_VALIDATED -> PromotionEntityStatus.TO_BE_VALIDATED;
            case io.gravitee.apim.core.promotion.model.PromotionStatus.ACCEPTED -> PromotionEntityStatus.ACCEPTED;
            case io.gravitee.apim.core.promotion.model.PromotionStatus.REJECTED -> PromotionEntityStatus.REJECTED;
            case io.gravitee.apim.core.promotion.model.PromotionStatus.ERROR -> PromotionEntityStatus.ERROR;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)promotionStatus));
        };
    }

    @Override
    public PromotionRequestEntity toRestApiModel(PromotionRequest promotionRequest) {
        if (promotionRequest == null) {
            return null;
        }
        PromotionRequestEntity promotionRequestEntity = new PromotionRequestEntity();
        promotionRequestEntity.setTargetEnvCockpitId(promotionRequest.getTargetEnvCockpitId());
        promotionRequestEntity.setTargetEnvName(promotionRequest.getTargetEnvName());
        return promotionRequestEntity;
    }

    protected io.gravitee.apim.core.promotion.model.PromotionStatus promotionStatusToPromotionStatus(PromotionStatus promotionStatus) {
        if (promotionStatus == null) {
            return null;
        }
        return switch (promotionStatus) {
            case PromotionStatus.CREATED -> io.gravitee.apim.core.promotion.model.PromotionStatus.CREATED;
            case PromotionStatus.TO_BE_VALIDATED -> io.gravitee.apim.core.promotion.model.PromotionStatus.TO_BE_VALIDATED;
            case PromotionStatus.ACCEPTED -> io.gravitee.apim.core.promotion.model.PromotionStatus.ACCEPTED;
            case PromotionStatus.REJECTED -> io.gravitee.apim.core.promotion.model.PromotionStatus.REJECTED;
            case PromotionStatus.ERROR -> io.gravitee.apim.core.promotion.model.PromotionStatus.ERROR;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(promotionStatus));
        };
    }

    protected io.gravitee.apim.core.promotion.model.PromotionStatus promotionEntityStatusToPromotionStatus(PromotionEntityStatus promotionEntityStatus) {
        if (promotionEntityStatus == null) {
            return null;
        }
        return switch (promotionEntityStatus) {
            case PromotionEntityStatus.CREATED -> io.gravitee.apim.core.promotion.model.PromotionStatus.CREATED;
            case PromotionEntityStatus.TO_BE_VALIDATED -> io.gravitee.apim.core.promotion.model.PromotionStatus.TO_BE_VALIDATED;
            case PromotionEntityStatus.ACCEPTED -> io.gravitee.apim.core.promotion.model.PromotionStatus.ACCEPTED;
            case PromotionEntityStatus.REJECTED -> io.gravitee.apim.core.promotion.model.PromotionStatus.REJECTED;
            case PromotionEntityStatus.ERROR -> io.gravitee.apim.core.promotion.model.PromotionStatus.ERROR;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(promotionEntityStatus));
        };
    }

    protected PromotionStatus promotionStatusToPromotionStatus1(io.gravitee.apim.core.promotion.model.PromotionStatus promotionStatus) {
        if (promotionStatus == null) {
            return null;
        }
        return switch (promotionStatus) {
            case io.gravitee.apim.core.promotion.model.PromotionStatus.CREATED -> PromotionStatus.CREATED;
            case io.gravitee.apim.core.promotion.model.PromotionStatus.TO_BE_VALIDATED -> PromotionStatus.TO_BE_VALIDATED;
            case io.gravitee.apim.core.promotion.model.PromotionStatus.ACCEPTED -> PromotionStatus.ACCEPTED;
            case io.gravitee.apim.core.promotion.model.PromotionStatus.REJECTED -> PromotionStatus.REJECTED;
            case io.gravitee.apim.core.promotion.model.PromotionStatus.ERROR -> PromotionStatus.ERROR;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)promotionStatus));
        };
    }
}

