/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.log.model.AggregatedMessageLog;
import io.gravitee.apim.core.log.model.MessageLog;
import io.gravitee.apim.infra.adapter.MessageLogAdapter;
import io.gravitee.repository.log.v4.model.message.AggregatedMessageLog;
import io.gravitee.repository.log.v4.model.message.MessageMetrics;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MessageLogAdapterImpl
implements MessageLogAdapter {
    @Override
    public AggregatedMessageLog toEntity(io.gravitee.repository.log.v4.model.message.AggregatedMessageLog messageLog) {
        if (messageLog == null) {
            return null;
        }
        AggregatedMessageLog.AggregatedMessageLogBuilder aggregatedMessageLog = AggregatedMessageLog.builder();
        aggregatedMessageLog.requestId(messageLog.getRequestId());
        aggregatedMessageLog.apiId(messageLog.getApiId());
        aggregatedMessageLog.timestamp(messageLog.getTimestamp());
        aggregatedMessageLog.clientIdentifier(messageLog.getClientIdentifier());
        aggregatedMessageLog.correlationId(messageLog.getCorrelationId());
        aggregatedMessageLog.parentCorrelationId(messageLog.getParentCorrelationId());
        aggregatedMessageLog.entrypoint(this.messageToMessage(messageLog.getEntrypoint()));
        aggregatedMessageLog.endpoint(this.messageToMessage(messageLog.getEndpoint()));
        aggregatedMessageLog.operation(this.mapOperation(messageLog));
        return aggregatedMessageLog.build();
    }

    @Override
    public List<AggregatedMessageLog> mapToAggregatedMessageLogs(List<io.gravitee.repository.log.v4.model.message.AggregatedMessageLog> messageLogs) {
        if (messageLogs == null) {
            return null;
        }
        ArrayList<AggregatedMessageLog> list = new ArrayList<AggregatedMessageLog>(messageLogs.size());
        for (io.gravitee.repository.log.v4.model.message.AggregatedMessageLog aggregatedMessageLog : messageLogs) {
            list.add(this.toEntity(aggregatedMessageLog));
        }
        return list;
    }

    @Override
    public List<MessageLog> mapToMessageMetrics(List<MessageMetrics> data) {
        if (data == null) {
            return null;
        }
        ArrayList<MessageLog> list = new ArrayList<MessageLog>(data.size());
        for (MessageMetrics messageMetrics : data) {
            list.add(this.messageMetricsToMessageLog(messageMetrics));
        }
        return list;
    }

    protected AggregatedMessageLog.Message messageToMessage(AggregatedMessageLog.Message message) {
        Map map1;
        if (message == null) {
            return null;
        }
        AggregatedMessageLog.Message.MessageBuilder message1 = AggregatedMessageLog.Message.builder();
        message1.id(message.getId());
        message1.timestamp(message.getTimestamp());
        message1.connectorId(message.getConnectorId());
        message1.payload(message.getPayload());
        Map map = message.getHeaders();
        if (map != null) {
            message1.headers(new LinkedHashMap<String, List<String>>(map));
        }
        if ((map1 = message.getMetadata()) != null) {
            message1.metadata(new LinkedHashMap<String, String>(map1));
        }
        return message1.build();
    }

    protected MessageLog messageMetricsToMessageLog(MessageMetrics messageMetrics) {
        Map map1;
        if (messageMetrics == null) {
            return null;
        }
        MessageLog.MessageLogBuilder messageLog = MessageLog.builder();
        messageLog.timestamp(messageMetrics.getTimestamp());
        messageLog.apiId(messageMetrics.getApiId());
        messageLog.apiName(messageMetrics.getApiName());
        messageLog.requestId(messageMetrics.getRequestId());
        messageLog.clientIdentifier(messageMetrics.getClientIdentifier());
        messageLog.correlationId(messageMetrics.getCorrelationId());
        messageLog.operation(messageMetrics.getOperation());
        messageLog.connectorType(messageMetrics.getConnectorType());
        messageLog.connectorId(messageMetrics.getConnectorId());
        messageLog.gateway(messageMetrics.getGateway());
        messageLog.contentLength(messageMetrics.getContentLength());
        messageLog.count(messageMetrics.getCount());
        messageLog.errorCount(messageMetrics.getErrorCount());
        messageLog.countIncrement(messageMetrics.getCountIncrement());
        messageLog.errorCountIncrement(messageMetrics.getErrorCountIncrement());
        messageLog.error(messageMetrics.isError());
        messageLog.gatewayLatencyMs(messageMetrics.getGatewayLatencyMs());
        Map map = messageMetrics.getCustom();
        if (map != null) {
            messageLog.custom(new LinkedHashMap<String, String>(map));
        }
        if ((map1 = messageMetrics.getAdditionalMetrics()) != null) {
            messageLog.additionalMetrics(new LinkedHashMap<String, Object>(map1));
        }
        return messageLog.build();
    }
}

