/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.infra.adapter.GroupAdapter;
import io.gravitee.repository.management.model.Group;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.GroupEventRule;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GroupAdapterImpl
implements GroupAdapter {
    @Override
    public io.gravitee.apim.core.group.model.Group toModel(Group group) {
        if (group == null) {
            return null;
        }
        Group.GroupBuilder group1 = io.gravitee.apim.core.group.model.Group.builder();
        group1.id(group.getId());
        group1.environmentId(group.getEnvironmentId());
        group1.name(group.getName());
        group1.eventRules(this.groupEventRuleListToGroupEventRuleList(group.getEventRules()));
        if (group.getCreatedAt() != null) {
            group1.createdAt(ZonedDateTime.ofInstant(group.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (group.getUpdatedAt() != null) {
            group1.updatedAt(ZonedDateTime.ofInstant(group.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        group1.maxInvitation(group.getMaxInvitation());
        group1.lockApiRole(group.isLockApiRole());
        group1.lockApplicationRole(group.isLockApplicationRole());
        group1.systemInvitation(group.isSystemInvitation());
        group1.emailInvitation(group.isEmailInvitation());
        group1.disableMembershipNotifications(group.isDisableMembershipNotifications());
        group1.apiPrimaryOwner(group.getApiPrimaryOwner());
        group1.origin(group.getOrigin());
        return group1.build();
    }

    @Override
    public Group toRepository(io.gravitee.apim.core.group.model.Group group) {
        if (group == null) {
            return null;
        }
        Group.GroupBuilder group1 = Group.builder();
        group1.id(group.getId());
        group1.environmentId(group.getEnvironmentId());
        group1.name(group.getName());
        group1.eventRules(this.groupEventRuleListToGroupEventRuleList1(group.getEventRules()));
        if (group.getCreatedAt() != null) {
            group1.createdAt(Date.from(group.getCreatedAt().toInstant()));
        }
        if (group.getUpdatedAt() != null) {
            group1.updatedAt(Date.from(group.getUpdatedAt().toInstant()));
        }
        group1.maxInvitation(group.getMaxInvitation());
        group1.lockApiRole(group.isLockApiRole());
        group1.lockApplicationRole(group.isLockApplicationRole());
        group1.systemInvitation(group.isSystemInvitation());
        group1.emailInvitation(group.isEmailInvitation());
        group1.disableMembershipNotifications(group.isDisableMembershipNotifications());
        group1.apiPrimaryOwner(group.getApiPrimaryOwner());
        group1.origin(group.getOrigin());
        return group1.build();
    }

    @Override
    public Group.GroupEvent mapEvent(GroupEvent source) {
        if (source == null) {
            return null;
        }
        return switch (source) {
            case GroupEvent.API_CREATE -> Group.GroupEvent.API_CREATE;
            case GroupEvent.APPLICATION_CREATE -> Group.GroupEvent.APPLICATION_CREATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(source));
        };
    }

    @Override
    public GroupEvent mapEvent(Group.GroupEvent source) {
        if (source == null) {
            return null;
        }
        return switch (source) {
            case Group.GroupEvent.API_CREATE -> GroupEvent.API_CREATE;
            case Group.GroupEvent.APPLICATION_CREATE -> GroupEvent.APPLICATION_CREATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)source));
        };
    }

    protected Group.GroupEventRule groupEventRuleToGroupEventRule(GroupEventRule groupEventRule) {
        if (groupEventRule == null) {
            return null;
        }
        Group.GroupEvent event = null;
        event = this.mapEvent(groupEventRule.getEvent());
        Group.GroupEventRule groupEventRule1 = new Group.GroupEventRule(event);
        return groupEventRule1;
    }

    protected List<Group.GroupEventRule> groupEventRuleListToGroupEventRuleList(List<GroupEventRule> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Group.GroupEventRule> list1 = new ArrayList<Group.GroupEventRule>(list.size());
        for (GroupEventRule groupEventRule : list) {
            list1.add(this.groupEventRuleToGroupEventRule(groupEventRule));
        }
        return list1;
    }

    protected GroupEventRule groupEventRuleToGroupEventRule1(Group.GroupEventRule groupEventRule) {
        if (groupEventRule == null) {
            return null;
        }
        GroupEventRule groupEventRule1 = new GroupEventRule();
        groupEventRule1.setEvent(this.mapEvent(groupEventRule.event()));
        return groupEventRule1;
    }

    protected List<GroupEventRule> groupEventRuleListToGroupEventRuleList1(List<Group.GroupEventRule> list) {
        if (list == null) {
            return null;
        }
        ArrayList<GroupEventRule> list1 = new ArrayList<GroupEventRule>(list.size());
        for (Group.GroupEventRule groupEventRule : list) {
            list1.add(this.groupEventRuleToGroupEventRule1(groupEventRule));
        }
        return list1;
    }
}

