/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.infra.adapter.ConnectionLogAdapter;
import io.gravitee.repository.log.v4.model.connection.ConnectionDiagnostic;
import io.gravitee.repository.log.v4.model.connection.ConnectionLogDetail;
import io.gravitee.repository.log.v4.model.connection.Metrics;
import io.gravitee.repository.log.v4.model.connection.MetricsQuery;
import io.gravitee.rest.api.model.analytics.Range;
import io.gravitee.rest.api.model.v4.log.connection.BaseConnectionLog;
import io.gravitee.rest.api.model.v4.log.connection.ConnectionDiagnosticModel;
import io.gravitee.rest.api.model.v4.log.connection.ConnectionLogDetail;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConnectionLogAdapterImpl
implements ConnectionLogAdapter {
    @Override
    public BaseConnectionLog toEntity(Metrics connectionLog) {
        if (connectionLog == null) {
            return null;
        }
        BaseConnectionLog.BaseConnectionLogBuilder baseConnectionLog = BaseConnectionLog.builder();
        baseConnectionLog.apiId(connectionLog.getApiId());
        baseConnectionLog.requestId(connectionLog.getRequestId());
        baseConnectionLog.timestamp(connectionLog.getTimestamp());
        baseConnectionLog.applicationId(connectionLog.getApplicationId());
        baseConnectionLog.planId(connectionLog.getPlanId());
        baseConnectionLog.clientIdentifier(connectionLog.getClientIdentifier());
        baseConnectionLog.transactionId(connectionLog.getTransactionId());
        baseConnectionLog.method(connectionLog.getMethod());
        baseConnectionLog.status(connectionLog.getStatus());
        baseConnectionLog.requestEnded(connectionLog.isRequestEnded());
        baseConnectionLog.entrypointId(connectionLog.getEntrypointId());
        baseConnectionLog.gateway(connectionLog.getGateway());
        baseConnectionLog.uri(connectionLog.getUri());
        baseConnectionLog.gatewayResponseTime(connectionLog.getGatewayResponseTime());
        baseConnectionLog.requestContentLength(Long.valueOf(connectionLog.getRequestContentLength()));
        baseConnectionLog.responseContentLength(Long.valueOf(connectionLog.getResponseContentLength()));
        baseConnectionLog.endpoint(connectionLog.getEndpoint());
        baseConnectionLog.message(connectionLog.getMessage());
        baseConnectionLog.errorKey(connectionLog.getErrorKey());
        baseConnectionLog.errorComponentName(connectionLog.getErrorComponentName());
        baseConnectionLog.errorComponentType(connectionLog.getErrorComponentType());
        baseConnectionLog.warnings(this.connectionDiagnosticListToConnectionDiagnosticModelList(connectionLog.getWarnings()));
        Map map = connectionLog.getAdditionalMetrics();
        if (map != null) {
            baseConnectionLog.additionalMetrics(new LinkedHashMap(map));
        }
        return baseConnectionLog.build();
    }

    @Override
    public List<BaseConnectionLog> toEntitiesList(List<Metrics> connectionLogs) {
        if (connectionLogs == null) {
            return null;
        }
        ArrayList<BaseConnectionLog> list = new ArrayList<BaseConnectionLog>(connectionLogs.size());
        for (Metrics metrics : connectionLogs) {
            list.add(this.toEntity(metrics));
        }
        return list;
    }

    @Override
    public ConnectionLogDetail toEntity(io.gravitee.repository.log.v4.model.connection.ConnectionLogDetail connectionLogDetail) {
        if (connectionLogDetail == null) {
            return null;
        }
        ConnectionLogDetail.ConnectionLogDetailBuilder connectionLogDetail1 = ConnectionLogDetail.builder();
        connectionLogDetail1.requestId(connectionLogDetail.getRequestId());
        connectionLogDetail1.apiId(connectionLogDetail.getApiId());
        connectionLogDetail1.timestamp(connectionLogDetail.getTimestamp());
        connectionLogDetail1.clientIdentifier(connectionLogDetail.getClientIdentifier());
        connectionLogDetail1.requestEnded(connectionLogDetail.isRequestEnded());
        connectionLogDetail1.entrypointRequest(this.requestToRequest(connectionLogDetail.getEntrypointRequest()));
        connectionLogDetail1.endpointRequest(this.requestToRequest(connectionLogDetail.getEndpointRequest()));
        connectionLogDetail1.entrypointResponse(this.responseToResponse(connectionLogDetail.getEntrypointResponse()));
        connectionLogDetail1.endpointResponse(this.responseToResponse(connectionLogDetail.getEndpointResponse()));
        connectionLogDetail1.message(connectionLogDetail.getMessage());
        connectionLogDetail1.errorKey(connectionLogDetail.getErrorKey());
        connectionLogDetail1.errorComponentName(connectionLogDetail.getErrorComponentName());
        connectionLogDetail1.errorComponentType(connectionLogDetail.getErrorComponentType());
        connectionLogDetail1.warnings(this.connectionDiagnosticListToConnectionDiagnosticModelList(connectionLogDetail.getWarnings()));
        return connectionLogDetail1.build();
    }

    @Override
    public MetricsQuery.Filter.ResponseTimeRange convert(Range range) {
        if (range == null) {
            return null;
        }
        MetricsQuery.Filter.ResponseTimeRange.ResponseTimeRangeBuilder responseTimeRange = MetricsQuery.Filter.ResponseTimeRange.builder();
        responseTimeRange.to(range.to());
        responseTimeRange.from(range.from());
        return responseTimeRange.build();
    }

    @Override
    public List<MetricsQuery.Filter.ResponseTimeRange> convert(List<Range> range) {
        if (range == null) {
            return null;
        }
        ArrayList<MetricsQuery.Filter.ResponseTimeRange> list = new ArrayList<MetricsQuery.Filter.ResponseTimeRange>(range.size());
        for (Range range1 : range) {
            list.add(this.convert(range1));
        }
        return list;
    }

    @Override
    public ConnectionDiagnosticModel convert(ConnectionDiagnostic connectionDiagnostic) {
        if (connectionDiagnostic == null) {
            return null;
        }
        ConnectionDiagnosticModel.ConnectionDiagnosticModelBuilder connectionDiagnosticModel = ConnectionDiagnosticModel.builder();
        connectionDiagnosticModel.componentType(connectionDiagnostic.getComponentType());
        connectionDiagnosticModel.componentName(connectionDiagnostic.getComponentName());
        connectionDiagnosticModel.key(connectionDiagnostic.getKey());
        connectionDiagnosticModel.message(connectionDiagnostic.getMessage());
        return connectionDiagnosticModel.build();
    }

    protected List<ConnectionDiagnosticModel> connectionDiagnosticListToConnectionDiagnosticModelList(List<ConnectionDiagnostic> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ConnectionDiagnosticModel> list1 = new ArrayList<ConnectionDiagnosticModel>(list.size());
        for (ConnectionDiagnostic connectionDiagnostic : list) {
            list1.add(this.convert(connectionDiagnostic));
        }
        return list1;
    }

    protected ConnectionLogDetail.Request requestToRequest(ConnectionLogDetail.Request request) {
        if (request == null) {
            return null;
        }
        ConnectionLogDetail.Request.RequestBuilder request1 = ConnectionLogDetail.Request.builder();
        request1.method(request.getMethod());
        request1.uri(request.getUri());
        Map map = request.getHeaders();
        if (map != null) {
            request1.headers(new LinkedHashMap(map));
        }
        request1.body(request.getBody());
        return request1.build();
    }

    protected ConnectionLogDetail.Response responseToResponse(ConnectionLogDetail.Response response) {
        if (response == null) {
            return null;
        }
        ConnectionLogDetail.Response.ResponseBuilder response1 = ConnectionLogDetail.Response.builder();
        response1.status(response.getStatus());
        Map map = response.getHeaders();
        if (map != null) {
            response1.headers(new LinkedHashMap(map));
        }
        response1.body(response.getBody());
        return response1.build();
    }
}

