/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.infra.adapter.ApiAdapterDecorator;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.definition.model.ApiDefinition;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.federation.FederatedAgent;
import io.gravitee.definition.model.federation.FederatedApi;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.federation.FederatedApiAgentEntity;
import io.gravitee.rest.api.model.federation.FederatedApiEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativeApiEntity;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.mapstruct.DecoratedWith;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ValueMapping;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper(uses={PlanAdapter.class})
@DecoratedWith(value=ApiAdapterDecorator.class)
public interface ApiAdapter {
    public static final Logger LOGGER = LoggerFactory.getLogger(ApiAdapter.class);
    public static final ApiAdapter INSTANCE = (ApiAdapter)Mappers.getMapper(ApiAdapter.class);

    @Mapping(target="apiDefinitionValue", expression="java(toApiDefinition(source))")
    public io.gravitee.apim.core.api.model.Api toCoreModel(io.gravitee.repository.management.model.Api var1);

    default public ApiDefinition toApiDefinition(io.gravitee.repository.management.model.Api source) {
        DefinitionVersion definitionVersion = source.getDefinitionVersion();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"V4", "FEDERATED", "FEDERATED_AGENT", "V1", "V2"}, (DefinitionVersion)definitionVersion, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (source.getType() != ApiType.NATIVE) {
                    yield (ApiDefinition)this.deserialize(source, Api.class);
                }
                yield (ApiDefinition)this.deserialize(source, NativeApi.class);
            }
            case 1 -> this.deserialize(source, FederatedApi.class);
            case 2 -> null;
            case 3, 4 -> this.deserialize(source, io.gravitee.definition.model.Api.class);
            case -1 -> this.deserialize(source, io.gravitee.definition.model.Api.class);
        };
    }

    public Stream<io.gravitee.apim.core.api.model.Api> toCoreModelStream(Stream<io.gravitee.repository.management.model.Api> var1);

    @Mapping(target="definition", expression="java(serializeApiDefinition(source))")
    public io.gravitee.repository.management.model.Api toRepository(io.gravitee.apim.core.api.model.Api var1);

    public Stream<io.gravitee.repository.management.model.Api> toRepositoryStream(Stream<io.gravitee.apim.core.api.model.Api> var1);

    @Mappings(value={@Mapping(target="apiVersion", source="version"), @Mapping(target="tags", source="apiDefinitionHttpV4.tags"), @Mapping(target="listeners", source="apiDefinitionHttpV4.listeners"), @Mapping(target="endpointGroups", source="apiDefinitionHttpV4.endpointGroups"), @Mapping(target="analytics", source="apiDefinitionHttpV4.analytics"), @Mapping(target="flowExecution", source="apiDefinitionHttpV4.flowExecution"), @Mapping(target="flows", source="apiDefinitionHttpV4.flows"), @Mapping(target="failover", source="apiDefinitionHttpV4.failover")})
    public NewApiEntity toNewApiEntity(io.gravitee.apim.core.api.model.Api var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="disableMembershipNotifications", expression="java(!spec.isNotifyMembers())"), @Mapping(target="listeners", expression="java((List<Listener>) spec.getListeners())"), @Mapping(target="endpointGroups", expression="java((List<EndpointGroup>) spec.getEndpointGroups())"), @Mapping(target="flows", expression="java((List<Flow>) spec.getFlows())")})
    public UpdateApiEntity toUpdateApiEntity(ApiCRDSpec var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(target="id", source="api.id"), @Mapping(target="name", source="api.name"), @Mapping(target="definitionVersion", source="api.definitionVersion"), @Mapping(target="type", source="api.type"), @Mapping(target="tags", source="api.tags"), @Mapping(target="apiVersion", source="api.version"), @Mapping(target="lifecycleState", source="api.apiLifecycleState")})
    public UpdateApiEntity toUpdateApiEntity(io.gravitee.apim.core.api.model.Api var1, Api var2);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="metadata", ignore=true), @Mapping(target="listeners", expression="java((List<Listener>) api.getListeners())")})
    public ApiEntity toApiEntity(ApiCRDSpec var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="metadata", ignore=true), @Mapping(target="listeners", expression="java((List<Listener>) api.getApiListeners())")})
    public ApiEntity toApiEntity(io.gravitee.apim.core.api.model.Api var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="metadata", ignore=true), @Mapping(target="tags", source="apiDefinitionNativeV4.tags"), @Mapping(target="listeners", source="apiDefinitionNativeV4.listeners"), @Mapping(target="endpointGroups", source="apiDefinitionNativeV4.endpointGroups"), @Mapping(target="flows", source="apiDefinitionNativeV4.flows"), @Mapping(target="resources", source="apiDefinitionNativeV4.resources"), @Mapping(target="services", source="apiDefinitionNativeV4.services"), @Mapping(target="properties", source="apiDefinitionNativeV4.properties"), @Mapping(target="state", source="lifecycleState"), @Mapping(target="lifecycleState", source="apiLifecycleState")})
    public NativeApiEntity toNativeApiEntity(io.gravitee.apim.core.api.model.Api var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="source.version", target="apiVersion"), @Mapping(source="source.id", target="id"), @Mapping(target="primaryOwner", source="primaryOwnerEntity"), @Mapping(target="referenceId", source="source.environmentId"), @Mapping(target="referenceType", constant="ENVIRONMENT"), @Mapping(source="source.apiLifecycleState", target="lifecycleState")})
    public FederatedApiEntity toFederatedApiEntity(io.gravitee.repository.management.model.Api var1, PrimaryOwnerEntity var2);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(target="apiVersion", source="source.version"), @Mapping(target="id", source="source.id"), @Mapping(target="primaryOwner", source="primaryOwnerEntity"), @Mapping(target="referenceId", source="source.environmentId"), @Mapping(target="referenceType", constant="ENVIRONMENT"), @Mapping(target="lifecycleState", source="source.apiLifecycleState"), @Mapping(target="provider", source="agent.provider"), @Mapping(target="defaultInputModes", source="agent.defaultInputModes"), @Mapping(target="defaultOutputModes", source="agent.defaultOutputModes"), @Mapping(target="capabilities", expression="java(capabilities(agent))"), @Mapping(target="skills", source="agent.skills"), @Mapping(target="securitySchemes", source="agent.securitySchemes"), @Mapping(target="security", source="agent.security"), @Mapping(target="name", source="source.name"), @Mapping(target="definitionVersion", source="source.definitionVersion"), @Mapping(target="description", source="source.description"), @Mapping(target="originContext", source="originContext")})
    public FederatedApiAgentEntity toFederatedAgentEntity(io.gravitee.repository.management.model.Api var1, FederatedAgent var2, PrimaryOwnerEntity var3, OriginContext.Integration var4);

    default public Collection<String> capabilities(FederatedAgent agent) {
        return agent == null || agent.getCapabilities() == null ? null : agent.getCapabilities().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toList();
    }

    @Mappings(value={@Mapping(source="state", target="lifecycleState"), @Mapping(source="lifecycleState", target="apiLifecycleState")})
    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    public io.gravitee.apim.core.api.model.Api fromApiEntity(GenericApiEntity var1);

    default public <T> T deserialize(io.gravitee.repository.management.model.Api api, Class<T> clazz) {
        if (api.getDefinition() == null) {
            return null;
        }
        try {
            return (T)GraviteeJacksonMapper.getInstance().readValue(api.getDefinition(), clazz);
        }
        catch (IOException ioe) {
            LOGGER.error("Unexpected error while deserializing V4 API definition", (Throwable)ioe);
            return null;
        }
    }

    default public String serializeApiDefinition(io.gravitee.apim.core.api.model.Api api) {
        ApiDefinition apiDefinition = api.getApiDefinitionValue();
        Objects.requireNonNull(apiDefinition);
        ApiDefinition apiDefinition2 = apiDefinition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{io.gravitee.definition.model.Api.class, NativeApi.class, Api.class, FederatedApi.class, FederatedAgent.class}, (Object)apiDefinition2, n)) {
            case 0 -> {
                io.gravitee.definition.model.Api v2 = (io.gravitee.definition.model.Api)apiDefinition2;
                yield this.serialize(v2, "V2 API");
            }
            case 1 -> {
                NativeApi nativeApi = (NativeApi)apiDefinition2;
                yield this.serialize(nativeApi, "V4 Native API");
            }
            case 2 -> {
                Api v4 = (Api)apiDefinition2;
                yield this.serialize(v4, "V4 API");
            }
            case 3 -> {
                FederatedApi federatedApi = (FederatedApi)apiDefinition2;
                yield this.serialize(federatedApi, "Federated API");
            }
            case 4 -> {
                FederatedAgent federatedAgent = (FederatedAgent)apiDefinition2;
                yield this.serialize(federatedAgent, "Federated Agent");
            }
            default -> null;
        };
    }

    default public <T> String serialize(T value, String name) {
        try {
            return GraviteeJacksonMapper.getInstance().writeValueAsString(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected error while serializing " + name + " definition", ioe);
        }
    }
}

