/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.promotion.domain_service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.environment.crud_service.EnvironmentCrudService;
import io.gravitee.apim.core.environment.model.Environment;
import io.gravitee.apim.core.promotion.crud_service.PromotionCrudService;
import io.gravitee.apim.core.promotion.model.Promotion;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;

@DomainService
public class PromotionContextDomainService {
    private final PromotionCrudService promotionCrudService;
    private final ApiCrudService apiCrudService;
    private final ApiQueryService apiQueryService;
    private final EnvironmentCrudService environmentCrudService;
    private final JsonMapper jsonMapper;

    public PromotionContextDomainService(PromotionCrudService promotionCrudService, ApiCrudService apiCrudService, ApiQueryService apiQueryService, EnvironmentCrudService environmentCrudService, JsonMapper jsonMapper) {
        this.promotionCrudService = promotionCrudService;
        this.apiCrudService = apiCrudService;
        this.apiQueryService = apiQueryService;
        this.environmentCrudService = environmentCrudService;
        this.jsonMapper = jsonMapper;
    }

    public PromotionContext getPromotionContext(String promotionId, boolean isAccepted) {
        Promotion promotion = this.promotionCrudService.getById(promotionId);
        Api api = this.apiCrudService.get(promotion.getApiId());
        Environment environment = this.environmentCrudService.getByCockpitId(promotion.getTargetEnvCockpitId());
        Optional<Api> targetApiOpt = this.apiQueryService.findByEnvironmentIdAndCrossId(environment.getId(), api.getCrossId());
        DefinitionVersion expectedDefinitionVersion = this.getPromotionDefinitionVersion(promotion);
        if (isAccepted && targetApiOpt.isPresent() && targetApiOpt.get().getDefinitionVersion() != expectedDefinitionVersion) {
            throw new IllegalStateException("An API with the same crossId already exists with a different definition version in the target environment");
        }
        return new PromotionContext(promotion, expectedDefinitionVersion, targetApiOpt.orElse(null), environment.getId());
    }

    private DefinitionVersion getPromotionDefinitionVersion(Promotion promotion) {
        try {
            JsonNode root = this.jsonMapper.readTree(promotion.getApiDefinition());
            JsonNode graviteeNode = root.findValue("gravitee");
            if (graviteeNode != null && "2.0.0".equals(graviteeNode.asText())) {
                return DefinitionVersion.V2;
            }
            JsonNode definitionVersionNode = root.findValue("definitionVersion");
            if (definitionVersionNode != null && !definitionVersionNode.isNull()) {
                return DefinitionVersion.valueOf((String)definitionVersionNode.asText());
            }
        }
        catch (Exception e) {
            throw new TechnicalManagementException("An error occurred while try to parse promotion definition version " + promotion.getId());
        }
        throw new IllegalStateException("Could not determine definition version for promotion " + promotion.getId());
    }

    public record PromotionContext(Promotion promotion, DefinitionVersion expectedDefinitionVersion, Api existingPromotedApi, String targetEnvId) {
    }
}

