/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.model;

import io.gravitee.apim.core.portal_page.model.PortalArea;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemType;
import io.gravitee.apim.core.portal_page.model.PortalVisibility;
import io.gravitee.apim.core.portal_page.model.UpdatePortalNavigationItem;
import jakarta.annotation.Nonnull;
import lombok.Generated;

public final class PortalNavigationLink
extends PortalNavigationItem {
    private static final PortalNavigationItemType TYPE = PortalNavigationItemType.LINK;
    @Nonnull
    private String url;

    public PortalNavigationLink(@Nonnull PortalNavigationItemId id, @Nonnull String organizationId, @Nonnull String environmentId, @Nonnull String title, @Nonnull PortalArea area, @Nonnull Integer order, @Nonnull String url, @Nonnull Boolean published, @Nonnull PortalVisibility visibility) {
        super(id, organizationId, environmentId, title, area, order, published, visibility);
        this.url = url;
    }

    @Override
    public PortalNavigationItemType getType() {
        return TYPE;
    }

    @Override
    public void update(UpdatePortalNavigationItem navItem) {
        super.update(navItem);
        this.setUrl(navItem.getUrl().trim());
    }

    @Generated
    protected PortalNavigationLink(PortalNavigationLinkBuilder<?, ?> b) {
        super(b);
        this.url = b.url;
        if (this.url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
    }

    @Generated
    public static PortalNavigationLinkBuilder<?, ?> builder() {
        return new PortalNavigationLinkBuilderImpl();
    }

    @Nonnull
    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setUrl(@Nonnull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    @Generated
    public static abstract class PortalNavigationLinkBuilder<C extends PortalNavigationLink, B extends PortalNavigationLinkBuilder<C, B>>
    extends PortalNavigationItem.PortalNavigationItemBuilder<C, B> {
        @Generated
        private String url;

        @Generated
        public B url(@Nonnull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PortalNavigationLink.PortalNavigationLinkBuilder(super=" + super.toString() + ", url=" + this.url + ")";
        }
    }

    @Generated
    private static final class PortalNavigationLinkBuilderImpl
    extends PortalNavigationLinkBuilder<PortalNavigationLink, PortalNavigationLinkBuilderImpl> {
        @Generated
        private PortalNavigationLinkBuilderImpl() {
        }

        @Override
        @Generated
        protected PortalNavigationLinkBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PortalNavigationLink build() {
            return new PortalNavigationLink(this);
        }
    }
}

