/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.portal_page.exception.HomepageAlreadyExistsException;
import io.gravitee.apim.core.portal_page.exception.InvalidPortalNavigationItemDataException;
import io.gravitee.apim.core.portal_page.exception.InvalidUrlFormatException;
import io.gravitee.apim.core.portal_page.exception.ItemAlreadyExistsException;
import io.gravitee.apim.core.portal_page.exception.PageContentNotFoundException;
import io.gravitee.apim.core.portal_page.exception.ParentAreaMismatchException;
import io.gravitee.apim.core.portal_page.exception.ParentNotFoundException;
import io.gravitee.apim.core.portal_page.exception.ParentTypeMismatchException;
import io.gravitee.apim.core.portal_page.model.CreatePortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalArea;
import io.gravitee.apim.core.portal_page.model.PortalNavigationFolder;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemType;
import io.gravitee.apim.core.portal_page.model.PortalNavigationLink;
import io.gravitee.apim.core.portal_page.model.PortalNavigationPage;
import io.gravitee.apim.core.portal_page.model.PortalPageContent;
import io.gravitee.apim.core.portal_page.model.PortalPageContentId;
import io.gravitee.apim.core.portal_page.model.UpdatePortalNavigationItem;
import io.gravitee.apim.core.portal_page.query_service.PortalNavigationItemsQueryService;
import io.gravitee.apim.core.portal_page.query_service.PortalPageContentQueryService;
import java.lang.runtime.SwitchBootstraps;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

@DomainService
public class PortalNavigationItemValidatorService {
    private final PortalNavigationItemsQueryService navigationItemsQueryService;
    private final PortalPageContentQueryService pageContentQueryService;

    public void validate(CreatePortalNavigationItem item, String environmentId) {
        this.validateItem(item, environmentId);
        this.validateParent(item.getParentId(), item.getArea(), environmentId);
    }

    private void validateItem(CreatePortalNavigationItem item, String environmentId) {
        Optional<PortalPageContent> existingPageContent;
        PortalPageContentId contentId;
        List<PortalNavigationItem> existingHomepage;
        PortalNavigationItem existingItem;
        PortalNavigationItemId itemId = item.getId();
        if (itemId != null && (existingItem = this.navigationItemsQueryService.findByIdAndEnvironmentId(environmentId, itemId)) != null) {
            throw new ItemAlreadyExistsException(itemId.toString());
        }
        if (item.getArea().equals((Object)PortalArea.HOMEPAGE) && !(existingHomepage = this.navigationItemsQueryService.findTopLevelItemsByEnvironmentIdAndPortalArea(environmentId, item.getArea())).isEmpty()) {
            throw new HomepageAlreadyExistsException();
        }
        if (item.getType() == PortalNavigationItemType.PAGE && (contentId = item.getPortalPageContentId()) != null && (existingPageContent = this.pageContentQueryService.findById(contentId)).isEmpty()) {
            throw new PageContentNotFoundException(contentId.toString());
        }
        if (item.getType() == PortalNavigationItemType.LINK && !this.isValidUrl(item.getUrl())) {
            throw new InvalidUrlFormatException();
        }
    }

    private void validateParent(PortalNavigationItemId parentId, PortalArea itemArea, String environmentId) {
        if (parentId == null) {
            return;
        }
        PortalNavigationItem parentItem = this.navigationItemsQueryService.findByIdAndEnvironmentId(environmentId, parentId);
        if (parentItem == null) {
            throw new ParentNotFoundException(parentId.toString());
        }
        if (!(parentItem instanceof PortalNavigationFolder)) {
            throw new ParentTypeMismatchException(parentId.toString());
        }
        if (!parentItem.getArea().equals((Object)itemArea)) {
            throw new ParentAreaMismatchException(parentId.toString());
        }
    }

    private boolean isValidUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void validateToUpdate(UpdatePortalNavigationItem toUpdate, PortalNavigationItem existingItem) {
        this.enforceTypeConsistency(existingItem, toUpdate.getType());
        PortalNavigationItemId payloadParentId = toUpdate.getParentId();
        this.validateParent(payloadParentId, existingItem.getArea(), existingItem.getEnvironmentId());
        if (toUpdate.getTitle().isBlank()) {
            throw InvalidPortalNavigationItemDataException.fieldIsEmpty("title");
        }
        if (toUpdate.getType() == PortalNavigationItemType.LINK && !this.isValidUrl(toUpdate.getUrl())) {
            throw new InvalidUrlFormatException();
        }
    }

    private void enforceTypeConsistency(PortalNavigationItem existing, PortalNavigationItemType requestedType) {
        PortalNavigationItemType existingType;
        PortalNavigationItem portalNavigationItem = existing;
        Objects.requireNonNull(portalNavigationItem);
        PortalNavigationItem portalNavigationItem2 = portalNavigationItem;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PortalNavigationFolder.class, PortalNavigationPage.class, PortalNavigationLink.class}, (Object)portalNavigationItem2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PortalNavigationFolder ignored = (PortalNavigationFolder)portalNavigationItem2;
                PortalNavigationItemType portalNavigationItemType = PortalNavigationItemType.FOLDER;
                break;
            }
            case 1: {
                PortalNavigationPage ignored = (PortalNavigationPage)portalNavigationItem2;
                PortalNavigationItemType portalNavigationItemType = PortalNavigationItemType.PAGE;
                break;
            }
            case 2: {
                PortalNavigationLink ignored = (PortalNavigationLink)portalNavigationItem2;
                PortalNavigationItemType portalNavigationItemType = existingType = PortalNavigationItemType.LINK;
            }
        }
        if (existingType != requestedType) {
            throw InvalidPortalNavigationItemDataException.typeMismatch(requestedType.toString(), existingType.toString());
        }
    }

    @Generated
    public PortalNavigationItemValidatorService(PortalNavigationItemsQueryService navigationItemsQueryService, PortalPageContentQueryService pageContentQueryService) {
        this.navigationItemsQueryService = navigationItemsQueryService;
        this.pageContentQueryService = pageContentQueryService;
    }
}

