/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api_health.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.exception.TcpProxyNotSupportedException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api_health.query_service.ApiHealthQueryService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;

@UseCase
public class AvailabilityUseCase {
    private final ApiCrudService apiCrudService;
    private final ApiHealthQueryService apiHealthQueryService;

    public Maybe<Output> execute(Input input) {
        return this.validateApiRequirements(input).flatMapMaybe(api -> this.apiHealthQueryService.availability(input.toApiFieldPeriodQuery())).map(e -> new Output(e.global(), e.byField()));
    }

    private Single<Api> validateApiRequirements(Input input) {
        return Single.fromCallable(() -> this.apiCrudService.get(input.api())).flatMap(api -> AvailabilityUseCase.validateApiMultiTenancyAccess(api, input.ctx().getEnvironmentId())).flatMap(this::validateApiIsNotTcp);
    }

    private Single<Api> validateApiIsNotTcp(Api api) {
        return api.isTcpProxy() ? Single.error((Throwable)new TcpProxyNotSupportedException(api.getId())) : Single.just((Object)api);
    }

    private static Single<Api> validateApiMultiTenancyAccess(Api api, String environmentId) {
        return !api.belongsToEnvironment(environmentId) ? Single.error((Throwable)new ApiNotFoundException(api.getId())) : Single.just((Object)api);
    }

    @Generated
    public AvailabilityUseCase(ApiCrudService apiCrudService, ApiHealthQueryService apiHealthQueryService) {
        this.apiCrudService = apiCrudService;
        this.apiHealthQueryService = apiHealthQueryService;
    }

    public record Input(ExecutionContext ctx, Instant since, Instant until, String api, String field) {
        public ApiHealthQueryService.ApiFieldPeriodQuery toApiFieldPeriodQuery() {
            return new ApiHealthQueryService.ApiFieldPeriodQuery(this.ctx.getOrganizationId(), this.ctx.getEnvironmentId(), this.api(), this.field(), this.since(), this.until());
        }
    }

    public record Output(float global, Map<String, Float> byField) {
    }
}

