/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.definition.model.ApiDefinition;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.nativeapi.NativePlan;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@UseCase
public class GetApiDefinitionUseCase {
    private final ApiCrudService apiCrudService;
    private final FlowCrudService flowCrudService;
    private final PlanQueryService planQueryService;

    public Output execute(Input input) {
        io.gravitee.apim.core.api.model.Api api = this.apiCrudService.get(input.apiId);
        ApiDefinition apiDefinition = api.getApiDefinitionValue();
        Objects.requireNonNull(apiDefinition);
        ApiDefinition apiDefinition2 = apiDefinition;
        int n = 0;
        ApiDefinition apiDefinition3 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NativeApi.class, Api.class, io.gravitee.definition.model.Api.class}, (Object)apiDefinition2, n)) {
            case 0 -> {
                NativeApi nativeApi = (NativeApi)apiDefinition2;
                yield this.enrichApiDefinitionNative(api, nativeApi);
            }
            case 1 -> {
                Api v4Api = (Api)apiDefinition2;
                yield this.enrichApiDefinitionV4(api, v4Api);
            }
            case 2 -> {
                io.gravitee.definition.model.Api v2Api = (io.gravitee.definition.model.Api)apiDefinition2;
                yield this.enrichApiDefinitionV2(api, v2Api);
            }
            default -> null;
        };
        return new Output(apiDefinition3);
    }

    private ApiDefinition enrichApiDefinitionV4(io.gravitee.apim.core.api.model.Api api, Api apiDefinitionHttpV4) {
        apiDefinitionHttpV4.setFlows(this.flowCrudService.getApiV4Flows(api.getId()));
        List<io.gravitee.definition.model.v4.plan.Plan> plans = this.planQueryService.findAllByApiId(api.getId()).stream().filter(plan -> plan.getPlanStatus() == PlanStatus.PUBLISHED || plan.getPlanStatus() == PlanStatus.DEPRECATED).map(Plan::getPlanDefinitionHttpV4).peek(planDefinition -> planDefinition.setFlows(this.flowCrudService.getPlanV4Flows(planDefinition.getId()))).toList();
        apiDefinitionHttpV4.setPlans(plans);
        return apiDefinitionHttpV4;
    }

    private ApiDefinition enrichApiDefinitionNative(io.gravitee.apim.core.api.model.Api api, NativeApi apiDefinitionNativeV4) {
        apiDefinitionNativeV4.setFlows(this.flowCrudService.getNativeApiFlows(api.getId()));
        List<NativePlan> plans = this.planQueryService.findAllByApiId(api.getId()).stream().filter(plan -> plan.getPlanStatus() == PlanStatus.PUBLISHED || plan.getPlanStatus() == PlanStatus.DEPRECATED).map(Plan::getPlanDefinitionNativeV4).peek(planDefinition -> planDefinition.setFlows(this.flowCrudService.getNativePlanFlows(planDefinition.getId()))).toList();
        apiDefinitionNativeV4.setPlans(plans);
        return apiDefinitionNativeV4;
    }

    private ApiDefinition enrichApiDefinitionV2(io.gravitee.apim.core.api.model.Api api, io.gravitee.definition.model.Api apiDefinition) {
        apiDefinition.setFlows(this.flowCrudService.getApiV2Flows(api.getId()));
        List<io.gravitee.definition.model.Plan> plans = this.planQueryService.findAllByApiId(api.getId()).stream().filter(plan -> plan.getPlanStatus() == PlanStatus.PUBLISHED || plan.getPlanStatus() == PlanStatus.DEPRECATED).map(Plan::getPlanDefinitionV2).peek(planDefinition -> planDefinition.setFlows(this.flowCrudService.getPlanV2Flows(planDefinition.getId()))).toList();
        apiDefinition.setPlans(plans);
        return apiDefinition;
    }

    @Generated
    public GetApiDefinitionUseCase(ApiCrudService apiCrudService, FlowCrudService flowCrudService, PlanQueryService planQueryService) {
        this.apiCrudService = apiCrudService;
        this.flowCrudService = flowCrudService;
        this.planQueryService = planQueryService;
    }

    public record Input(String apiId) {
    }

    public record Output(ApiDefinition apiDefinition) {
    }
}

