/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model.mapper;

import io.gravitee.definition.model.ssl.jks.JKSKeyStore;
import io.gravitee.definition.model.ssl.pem.PEMKeyStore;
import io.gravitee.plugin.configurations.ssl.KeyStore;
import io.gravitee.plugin.configurations.ssl.none.NoneKeyStore;
import io.gravitee.plugin.configurations.ssl.pkcs12.PKCS12KeyStore;
import java.lang.runtime.SwitchBootstraps;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class KeyStoreMigration {
    public static @Nullable KeyStore convert(@Nullable io.gravitee.definition.model.ssl.KeyStore v2KeyStore) {
        io.gravitee.definition.model.ssl.KeyStore keyStore = v2KeyStore;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JKSKeyStore.class, PEMKeyStore.class, io.gravitee.definition.model.ssl.pkcs12.PKCS12KeyStore.class, io.gravitee.definition.model.ssl.none.NoneKeyStore.class}, (Object)keyStore, n)) {
            case 0 -> {
                JKSKeyStore v2Jks = (JKSKeyStore)keyStore;
                yield KeyStoreMigration.convertJKS(v2Jks);
            }
            case 1 -> {
                PEMKeyStore v2Pem = (PEMKeyStore)keyStore;
                yield KeyStoreMigration.convertPEM(v2Pem);
            }
            case 2 -> {
                io.gravitee.definition.model.ssl.pkcs12.PKCS12KeyStore v2Pkcs12 = (io.gravitee.definition.model.ssl.pkcs12.PKCS12KeyStore)keyStore;
                yield KeyStoreMigration.convertPKCS12(v2Pkcs12);
            }
            case 3 -> {
                io.gravitee.definition.model.ssl.none.NoneKeyStore ignored = (io.gravitee.definition.model.ssl.none.NoneKeyStore)keyStore;
                yield KeyStoreMigration.convertNone();
            }
            case -1 -> null;
            default -> throw new IllegalArgumentException("Unsupported key store type: " + String.valueOf(v2KeyStore.getClass()));
        };
    }

    private static io.gravitee.plugin.configurations.ssl.jks.JKSKeyStore convertJKS(JKSKeyStore v2JKSKeyStore) {
        io.gravitee.plugin.configurations.ssl.jks.JKSKeyStore jKSKeyStore = new io.gravitee.plugin.configurations.ssl.jks.JKSKeyStore();
        jKSKeyStore.setPath(v2JKSKeyStore.getPath());
        jKSKeyStore.setContent(v2JKSKeyStore.getContent());
        jKSKeyStore.setPassword(v2JKSKeyStore.getPassword());
        return jKSKeyStore;
    }

    private static io.gravitee.plugin.configurations.ssl.pem.PEMKeyStore convertPEM(PEMKeyStore v2PEMKeyStore) {
        io.gravitee.plugin.configurations.ssl.pem.PEMKeyStore pemKeyStore = new io.gravitee.plugin.configurations.ssl.pem.PEMKeyStore();
        pemKeyStore.setKeyPath(v2PEMKeyStore.getKeyPath());
        pemKeyStore.setKeyContent(v2PEMKeyStore.getKeyContent());
        pemKeyStore.setCertPath(v2PEMKeyStore.getCertPath());
        pemKeyStore.setCertContent(v2PEMKeyStore.getCertContent());
        return pemKeyStore;
    }

    private static PKCS12KeyStore convertPKCS12(io.gravitee.definition.model.ssl.pkcs12.PKCS12KeyStore v2Pkcs12KeyStore) {
        PKCS12KeyStore pKCS12KeyStore = new PKCS12KeyStore();
        pKCS12KeyStore.setPath(v2Pkcs12KeyStore.getPath());
        pKCS12KeyStore.setPassword(v2Pkcs12KeyStore.getPassword());
        pKCS12KeyStore.setContent(v2Pkcs12KeyStore.getContent());
        return pKCS12KeyStore;
    }

    private static NoneKeyStore convertNone() {
        return new NoneKeyStore();
    }

    @Generated
    private KeyStoreMigration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

