/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service.import_definition;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.DeletePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.model.PlanWithFlows;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

@DomainService
class ImportDefinitionPlanDomainService {
    private final CreatePlanDomainService createPlanDomainService;
    private final UpdatePlanDomainService updatePlanDomainService;
    private final DeletePlanDomainService deletePlanDomainService;
    private final PlanCrudService planCrudService;

    ImportDefinitionPlanDomainService(CreatePlanDomainService createPlanDomainService, UpdatePlanDomainService updatePlanDomainService, DeletePlanDomainService deletePlanDomainService, PlanCrudService planCrudService) {
        this.createPlanDomainService = createPlanDomainService;
        this.updatePlanDomainService = updatePlanDomainService;
        this.deletePlanDomainService = deletePlanDomainService;
        this.planCrudService = planCrudService;
    }

    void upsertPlanWithFlows(Api api, Set<PlanWithFlows> plansWithFlows, AuditInfo auditInfo) {
        Collection<Plan> savedPlans = this.planCrudService.findByApiId(api.getId());
        HashSet crossIds = savedPlans.stream().map(Plan::getCrossId).collect(Collectors.toCollection(HashSet::new));
        if (plansWithFlows != null) {
            for (PlanWithFlows planWithFlow : plansWithFlows) {
                String crossId = planWithFlow.getCrossId();
                if (crossIds.contains(crossId)) {
                    this.updatePlanDomainService.update(planWithFlow, planWithFlow.getFlows(), Collections.emptyMap(), api, auditInfo);
                } else {
                    this.createPlanDomainService.create(planWithFlow, planWithFlow.getFlows(), api, auditInfo);
                }
                crossIds.remove(crossId);
            }
        }
        if (!crossIds.isEmpty()) {
            savedPlans.stream().filter(plan -> crossIds.contains(plan.getCrossId())).forEach(removedPlan -> this.deletePlanDomainService.delete((Plan)removedPlan, auditInfo));
        }
    }
}

