/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service.cockpit;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.domain_service.ApiStateDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.definition.model.v4.plan.Plan;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class DeployModelToApiDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployModelToApiDomainService.class);
    private final UpdateApiDomainService updateApiDomainService;
    private final ApiStateDomainService apiStateDomainService;

    public DeployModelToApiDomainService(UpdateApiDomainService updateApiDomainService, ApiStateDomainService apiStateDomainService) {
        this.updateApiDomainService = updateApiDomainService;
        this.apiStateDomainService = apiStateDomainService;
    }

    public ImportSwaggerDescriptorEntity configure(Mode mode, String swaggerDefinition) {
        ImportSwaggerDescriptorEntity.ImportSwaggerDescriptorEntityBuilder importSwaggerDescriptor = ImportSwaggerDescriptorEntity.builder().payload(swaggerDefinition);
        importSwaggerDescriptor.withDocumentation(true);
        if (mode == Mode.MOCKED || mode == Mode.PUBLISHED) {
            importSwaggerDescriptor.withPolicyPaths(true);
            importSwaggerDescriptor.withPolicies(List.of("mock"));
        }
        return importSwaggerDescriptor.build();
    }

    public Api manageApiState(Api api, AuditInfo audit, Mode mode) {
        if (mode == Mode.PUBLISHED) {
            log.debug("Published v4 API [id: {} / crossId: {}].", (Object)api.getId(), (Object)api.getCrossId());
            api.setVisibility(Api.Visibility.PUBLIC);
            api.setApiLifecycleState(Api.ApiLifecycleState.PUBLISHED);
        }
        Api updatedApi = this.updateApiDomainService.updateV4(api, audit);
        if (mode == Mode.MOCKED || mode == Mode.PUBLISHED) {
            log.debug("Started v4 API [id: {} / crossId: {}].", (Object)api.getId(), (Object)api.getCrossId());
            this.apiStateDomainService.start(api, audit);
        }
        if (!this.apiStateDomainService.isSynchronized(api, audit)) {
            this.apiStateDomainService.deploy(api, "Managed by Gravitee Cloud", audit);
        }
        return updatedApi;
    }

    public Plan createDefaultPlan() {
        return ((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)Plan.builder().id(UuidString.generateRandom())).name("Default plan")).mode(PlanMode.STANDARD)).status(PlanStatus.PUBLISHED)).security(PlanSecurity.builder().type("key-less").build())).build();
    }

    public static enum Mode {
        DOCUMENTED,
        MOCKED,
        PUBLISHED;

    }
}

