/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.validator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonHelper.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static String clearNullValues(String jsonPayload) {
        if (jsonPayload == null) {
            return jsonPayload;
        }
        try {
            Object staleObject = objectMapper.readValue(jsonPayload, Object.class);
            return objectMapper.writeValueAsString(staleObject);
        }
        catch (IOException e) {
            log.debug("Unable to remove 'null' values from policy configuration, return the original value", (Throwable)e);
            return jsonPayload;
        }
    }

    public static String getScope(String jsonPayload) {
        if (jsonPayload != null) {
            try {
                JsonNode jsonNode = (JsonNode)objectMapper.readValue(jsonPayload, JsonNode.class);
                if (jsonNode.has("scope")) {
                    return jsonNode.get("scope").asText();
                }
            }
            catch (IOException e) {
                log.debug("Unable to get SCOPE from policy configuration, return the null", (Throwable)e);
            }
        }
        return null;
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

