/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.transformer.entrypoints;

import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.service.impl.swagger.transformer.page.AbstractPageConfigurationSwaggerTransformer;
import io.gravitee.rest.api.service.swagger.OAIDescriptor;
import io.swagger.v3.oas.models.servers.Server;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntrypointsOAITransformer
extends AbstractPageConfigurationSwaggerTransformer<OAIDescriptor> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntrypointsOAITransformer.class);
    private final List<ApiEntrypointEntity> entrypoints;
    private final String contextPath;

    public EntrypointsOAITransformer(PageEntity page, List<ApiEntrypointEntity> entrypoints, String contextPath) {
        super(page);
        this.entrypoints = entrypoints;
        this.contextPath = contextPath;
    }

    @Override
    public void transform(OAIDescriptor descriptor) {
        if (this.asBoolean("entrypointsAsServers") && this.entrypoints != null && !this.entrypoints.isEmpty()) {
            ArrayList servers = new ArrayList();
            this.entrypoints.forEach(entrypoint -> {
                Server server = new Server();
                if (this.asBoolean("entrypointAsBasePath")) {
                    server.setUrl(entrypoint.getTarget());
                } else {
                    URI target = URI.create(entrypoint.getTarget());
                    server.setUrl(entrypoint.getTarget().substring(0, entrypoint.getTarget().indexOf(target.getRawPath())));
                }
                servers.add(server);
            });
            descriptor.getSpecification().setServers(servers);
        } else if (this.asBoolean("entrypointAsBasePath") && descriptor.getSpecification().getServers() != null) {
            descriptor.getSpecification().getServers().forEach(server -> {
                URI newURI = URI.create(server.getUrl());
                try {
                    server.setUrl(new URI(newURI.getScheme(), newURI.getUserInfo(), newURI.getHost(), newURI.getPort(), this.contextPath, newURI.getQuery(), newURI.getFragment()).toString());
                }
                catch (URISyntaxException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
    }
}

