/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.common;

import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;

public final class IdBuilder {
    private String hrid;
    private String environmentId;
    private String organizationId;
    private String extraId;

    private IdBuilder() {
    }

    public static IdBuilder builder(AuditInfo auditInfo, String hrid) {
        IdBuilder builder = new IdBuilder();
        builder.hrid = hrid;
        builder.organizationId = auditInfo.organizationId();
        builder.environmentId = auditInfo.environmentId();
        return builder;
    }

    public static IdBuilder builder(ExecutionContext executionContext, String hrid) {
        IdBuilder builder = new IdBuilder();
        builder.hrid = hrid;
        builder.organizationId = executionContext.getOrganizationId();
        builder.environmentId = executionContext.getEnvironmentId();
        return builder;
    }

    public IdBuilder withExtraId(String extraId) {
        this.extraId = extraId;
        return this;
    }

    public String buildCrossId() {
        return UuidString.generateFrom(this.organizationId, this.hrid);
    }

    public String buildId() {
        if (this.extraId == null) {
            return UuidString.generateFrom(this.buildCrossId(), this.environmentId);
        }
        return UuidString.generateFrom(this.buildCrossId(), this.environmentId, this.extraId);
    }
}

