/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.promotion;

import io.gravitee.apim.core.promotion.model.Promotion;
import io.gravitee.apim.core.promotion.query_service.PromotionQueryService;
import io.gravitee.apim.infra.adapter.PromotionAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PromotionRepository;
import io.gravitee.repository.management.api.search.PromotionCriteria;
import io.gravitee.repository.management.model.PromotionStatus;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PromotionQueryServiceImpl
implements PromotionQueryService {
    private final PromotionRepository promotionRepository;

    public PromotionQueryServiceImpl(@Lazy PromotionRepository promotionRepository) {
        this.promotionRepository = promotionRepository;
    }

    @Override
    public Page<Promotion> search(PromotionQueryService.PromotionQuery promotionQuery) throws TechnicalManagementException {
        PromotionCriteria.Builder criteria = new PromotionCriteria.Builder();
        if (promotionQuery.apiId() != null && !promotionQuery.apiId().isEmpty()) {
            criteria.apiId(promotionQuery.apiId());
        }
        if (!CollectionUtils.isEmpty(promotionQuery.statuses())) {
            criteria.statuses(promotionQuery.statuses().stream().map(status -> PromotionStatus.valueOf((String)status.name())).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(promotionQuery.targetEnvCockpitIds())) {
            criteria.targetEnvCockpitIds(promotionQuery.targetEnvCockpitIds().toArray(new String[0]));
        }
        if (promotionQuery.targetApiExists() != null) {
            criteria.targetApiExists(promotionQuery.targetApiExists());
        }
        try {
            return this.promotionRepository.search(criteria.build(), null, null).map(PromotionAdapter.INSTANCE::toCoreModel);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }
}

