/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.cluster;

import io.gravitee.apim.core.cluster.model.Cluster;
import io.gravitee.apim.core.cluster.model.ClusterSearchCriteria;
import io.gravitee.apim.core.cluster.query_service.ClusterQueryService;
import io.gravitee.apim.infra.adapter.ClusterAdapter;
import io.gravitee.apim.infra.adapter.ClusterSearchCriteriaAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.management.api.ClusterRepository;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import java.util.Optional;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ClusterQueryServiceImpl
implements ClusterQueryService {
    private final ClusterRepository clusterRepository;
    private final ClusterAdapter clusterAdapter;

    public ClusterQueryServiceImpl(@Lazy ClusterRepository clusterRepository, ClusterAdapter clusterAdapter) {
        this.clusterRepository = clusterRepository;
        this.clusterAdapter = clusterAdapter;
    }

    @Override
    public Page<Cluster> search(ClusterSearchCriteria criteria, Pageable pageable, Optional<Sortable> sortableOpt) {
        Page result = this.clusterRepository.search(ClusterSearchCriteriaAdapter.INSTANCE.toCriteriaForRepository(criteria), new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build(), sortableOpt.map(sortable -> new SortableBuilder().field(sortable.getField()).setAsc(sortable.isAscOrder()).build()));
        return result.map(this.clusterAdapter::fromRepository);
    }
}

