/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.newtai;

import io.gravitee.apim.core.newtai.exception.NewtAIReplyException;
import io.gravitee.apim.core.newtai.exception.NewtAiSubmitFeedbackException;
import io.gravitee.apim.core.newtai.model.ELGenFeedback;
import io.gravitee.apim.core.newtai.model.ELGenQuery;
import io.gravitee.apim.core.newtai.model.ELGenReply;
import io.gravitee.apim.core.newtai.service_provider.NewtAIProvider;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.apim.infra.apim.ApimProductInfoImpl;
import io.gravitee.cockpit.api.CockpitConnector;
import io.gravitee.cockpit.api.command.v1.newtai.elgen.ELCommand;
import io.gravitee.cockpit.api.command.v1.newtai.elgen.ELCommandPayload;
import io.gravitee.cockpit.api.command.v1.newtai.elgen.ELGenFeedbackCommand;
import io.gravitee.cockpit.api.command.v1.newtai.elgen.ELGenFeedbackCommandPayload;
import io.gravitee.cockpit.api.command.v1.newtai.elgen.ELReplyPayload;
import io.gravitee.exchange.api.command.Command;
import io.gravitee.exchange.api.command.CommandStatus;
import io.gravitee.exchange.api.command.Payload;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.exceptions.InstallationNotFoundException;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class NewtAIProviderImpl
implements NewtAIProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewtAIProviderImpl.class);
    private static final Pattern EL_MAPPING = Pattern.compile("^```(.*)```$", 32);
    private final CockpitConnector cockpitConnector;
    private final ApimProductInfoImpl apimMetadata;
    private final InstallationService installationService;

    public NewtAIProviderImpl(@Lazy CockpitConnector cockpitConnector, ApimProductInfoImpl apimMetadata, InstallationService installationService) {
        this.cockpitConnector = cockpitConnector;
        this.apimMetadata = apimMetadata;
        this.installationService = installationService;
    }

    @Override
    public Single<ELGenReply> generateEL(ELGenQuery query) {
        String installationId = (String)this.installationService.get().getAdditionalInformation().get("COCKPIT_INSTALLATION_ID");
        if (StringUtils.isEmpty(installationId)) {
            return Single.error((Throwable)new InstallationNotFoundException("Cockpit installation not found"));
        }
        ELCommand command = new ELCommand(new ELCommandPayload(query.message(), this.apimMetadata.getVersion(), query.properties(), installationId));
        return this.cockpitConnector.sendCommand((Command)command).onErrorResumeNext(error -> Single.error((Throwable)new NewtAIReplyException(command.getId(), this.getErrorMessage((Throwable)error), (Throwable)error))).map(reply -> {
            if (reply.getCommandStatus() == CommandStatus.ERROR) {
                throw new NewtAIReplyException(command.getId(), reply.getErrorDetails());
            }
            Payload patt0$temp = reply.getPayload();
            if (patt0$temp instanceof ELReplyPayload) {
                ELReplyPayload payload = (ELReplyPayload)patt0$temp;
                return new Output(this.mapPayload(payload));
            }
            throw new NewtAIReplyException(command.getId(), "Unexpected reply payload:" + String.valueOf(reply.getPayload()));
        });
    }

    @Override
    public Completable submitFeedback(ELGenFeedback feedback) {
        ELGenFeedbackCommand command = new ELGenFeedbackCommand(new ELGenFeedbackCommandPayload(new ELReplyPayload.RequestId(feedback.chatId(), feedback.userMessageId(), feedback.agentMessageId()), feedback.answerHelpful()));
        return this.cockpitConnector.sendCommand((Command)command).onErrorResumeNext(error -> Single.error((Throwable)new NewtAiSubmitFeedbackException(command.getId(), this.getErrorMessage((Throwable)error), (Throwable)error))).flatMapCompletable(reply -> {
            if (reply.getCommandStatus() == CommandStatus.ERROR) {
                return Completable.error((Throwable)new NewtAiSubmitFeedbackException(command.getId(), reply.getErrorDetails()));
            }
            return Completable.complete();
        });
    }

    private ELReplyPayload mapPayload(ELReplyPayload payload) {
        Matcher matcher = EL_MAPPING.matcher(payload.message());
        return matcher.find() ? new ELReplyPayload(matcher.group(1), payload.feedbackId()) : payload;
    }

    private String getErrorMessage(Throwable error) {
        return error.getMessage() != null ? error.getMessage() : error.toString();
    }

    private static final class Output
    extends Record
    implements ELGenReply {
        private final String message;
        private final FeedbackId feedbackId;

        private Output(ELReplyPayload payload) {
            this(payload.message(), new FeedbackId(payload.feedbackId()));
        }

        private Output(String message, FeedbackId feedbackId) {
            this.message = message;
            this.feedbackId = feedbackId;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Output.class, "message;feedbackId", "message", "feedbackId"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Output.class, "message;feedbackId", "message", "feedbackId"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Output.class, "message;feedbackId", "message", "feedbackId"}, this, o);
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public FeedbackId feedbackId() {
            return this.feedbackId;
        }

        private record FeedbackId(String chatId, String userMessageId, String agentMessageId) implements ELGenReply.FeedbackId
        {
            private FeedbackId(ELReplyPayload.RequestId requestId) {
                this(requestId.chatId(), requestId.userMessageId(), requestId.agentMessageId());
            }
        }
    }
}

