/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.analytics_engine.processors;

import io.gravitee.apim.core.analytics_engine.domain_service.BucketNamesPostProcessor;
import io.gravitee.apim.core.analytics_engine.model.FacetBucketResponse;
import io.gravitee.apim.core.analytics_engine.model.FacetSpec;
import io.gravitee.apim.core.analytics_engine.model.FacetsResponse;
import io.gravitee.apim.core.analytics_engine.model.MetricFacetsResponse;
import io.gravitee.apim.core.analytics_engine.model.MetricsContext;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesBucketResponse;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesMetricResponse;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesResponse;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.application.ApplicationQuery;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class BucketNamesPostProcessorImpl
implements BucketNamesPostProcessor {
    private static final String UNKNOWN_APPLICATION = "Unknown";
    private static final Map<String, String> STATUS_CODE_GROUP_FROM_ES_KEY = Map.of("100-199", "1XX", "200-299", "2XX", "300-399", "3XX", "400-499", "4XX", "500-599", "5XX");
    private final ApplicationService applicationSearchService;

    @Override
    public FacetsResponse mapBucketNames(MetricsContext context, List<FacetSpec.Name> facets, FacetsResponse response) {
        List<FacetBucketResponse> buckets = response.metrics().stream().flatMap(r -> r.buckets().stream()).toList();
        Map<String, String> applications = this.populateApplicationNames(facets, buckets);
        MetricsContext updatedContext = context.withApplicationNameById(applications);
        List<MetricFacetsResponse> mappedMetrics = response.metrics().stream().map(metricsFacetResponse -> this.mapFacetMetrics(updatedContext, facets, (MetricFacetsResponse)metricsFacetResponse)).toList();
        return new FacetsResponse(mappedMetrics);
    }

    MetricFacetsResponse mapFacetMetrics(MetricsContext context, List<FacetSpec.Name> facets, MetricFacetsResponse metric) {
        List<FacetBucketResponse> mappedBuckets = this.mapFacetBuckets(context, facets, metric.buckets());
        return new MetricFacetsResponse(metric.metric(), mappedBuckets);
    }

    List<FacetBucketResponse> mapFacetBuckets(MetricsContext context, List<FacetSpec.Name> facets, List<FacetBucketResponse> buckets) {
        if (facets.isEmpty()) {
            return buckets;
        }
        return buckets.stream().map(bucket -> this.mapFacetBucket(context, facets, (FacetBucketResponse)bucket)).toList();
    }

    Map<String, String> loadApplicationNames(Set<String> applicationIds) {
        if (applicationIds.isEmpty()) {
            return Map.of();
        }
        Map<String, String> applications = this.getApplicationNamesByIds(applicationIds);
        applications.put("1", UNKNOWN_APPLICATION);
        return applications;
    }

    Map<String, String> getApplicationNamesByIds(Set<String> applicationIds) {
        ApplicationQuery query = new ApplicationQuery();
        query.setIds(applicationIds);
        List content = this.applicationSearchService.search(GraviteeContext.getExecutionContext(), query, null, null).getContent();
        return content.stream().collect(Collectors.toMap(ApplicationListItem::getId, ApplicationListItem::getName));
    }

    FacetBucketResponse mapFacetBucket(MetricsContext context, List<FacetSpec.Name> facets, FacetBucketResponse bucket) {
        String bucketName = switch (facets.getFirst()) {
            case FacetSpec.Name.HTTP_STATUS_CODE_GROUP -> STATUS_CODE_GROUP_FROM_ES_KEY.getOrDefault(bucket.key(), bucket.key());
            case FacetSpec.Name.API -> context.apiNameById().map(apis -> (String)apis.get(bucket.key())).orElse(bucket.key());
            case FacetSpec.Name.APPLICATION -> context.applicationNameById().map(applications -> (String)applications.get(bucket.key())).orElse(bucket.key());
            default -> bucket.key();
        };
        List<FacetBucketResponse> mappedBuckets = this.mapFacetBuckets(context, facets.subList(1, facets.size()), bucket.buckets());
        return new FacetBucketResponse(bucket.key(), bucketName, mappedBuckets, bucket.measures());
    }

    @Override
    public TimeSeriesResponse mapBucketNames(MetricsContext context, List<FacetSpec.Name> facets, TimeSeriesResponse response) {
        List<FacetBucketResponse> buckets = response.metrics().stream().filter(timeSeriesMetricResponse -> timeSeriesMetricResponse.buckets() != null).flatMap(timeSeriesMetricResponse -> timeSeriesMetricResponse.buckets().stream()).filter(timeSeriesBucketResponse -> timeSeriesBucketResponse.buckets() != null).flatMap(timeSeriesBucketResponse -> timeSeriesBucketResponse.buckets().stream()).toList();
        Map<String, String> applications = this.populateApplicationNames(facets, buckets);
        MetricsContext updatedContext = context.withApplicationNameById(applications);
        List<TimeSeriesMetricResponse> mappedMetrics = response.metrics().stream().map(metricsFacetResponse -> this.mapTimeSeriesMetrics(updatedContext, facets, (TimeSeriesMetricResponse)metricsFacetResponse)).toList();
        return new TimeSeriesResponse(mappedMetrics);
    }

    private TimeSeriesMetricResponse mapTimeSeriesMetrics(MetricsContext context, List<FacetSpec.Name> facets, TimeSeriesMetricResponse metric) {
        List<TimeSeriesBucketResponse> mappedBuckets = this.mapTimeSeriesBuckets(context, facets, metric.buckets());
        return new TimeSeriesMetricResponse(metric.name(), mappedBuckets);
    }

    private List<TimeSeriesBucketResponse> mapTimeSeriesBuckets(MetricsContext context, List<FacetSpec.Name> filters, List<TimeSeriesBucketResponse> buckets) {
        if (filters.isEmpty()) {
            return buckets;
        }
        return buckets.stream().map(bucket -> this.mapTimeSeriesBucket(context, filters, (TimeSeriesBucketResponse)bucket)).toList();
    }

    private TimeSeriesBucketResponse mapTimeSeriesBucket(MetricsContext context, List<FacetSpec.Name> facets, TimeSeriesBucketResponse bucket) {
        List<FacetBucketResponse> updatedBuckets = bucket.buckets().stream().map(b -> this.mapFacetBucket(context, facets, (FacetBucketResponse)b)).toList();
        return new TimeSeriesBucketResponse(bucket.key(), bucket.name(), bucket.timestamp(), updatedBuckets, bucket.measures());
    }

    private Map<String, String> populateApplicationNames(List<FacetSpec.Name> facets, List<FacetBucketResponse> buckets) {
        Set<String> applicationIds = this.getApplicationIdsFromBuckets(facets, buckets);
        return this.loadApplicationNames(applicationIds);
    }

    private Set<String> getApplicationIdsFromBuckets(List<FacetSpec.Name> facets, List<FacetBucketResponse> buckets) {
        if (facets.isEmpty()) {
            return Set.of();
        }
        if (facets.getFirst() == FacetSpec.Name.APPLICATION) {
            return buckets.stream().map(FacetBucketResponse::key).collect(Collectors.toSet());
        }
        return this.getApplicationIdsFromBuckets(facets.subList(1, facets.size()), buckets.stream().filter(b -> b.buckets() != null).flatMap(b -> b.buckets().stream()).toList());
    }

    @Generated
    public BucketNamesPostProcessorImpl(ApplicationService applicationSearchService) {
        this.applicationSearchService = applicationSearchService;
    }
}

