/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.log;

import io.gravitee.apim.core.log.crud_service.MessageLogsCrudService;
import io.gravitee.apim.core.log.model.MessageLog;
import io.gravitee.apim.infra.adapter.MessageLogAdapter;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.log.v4.api.MetricsRepository;
import io.gravitee.repository.log.v4.model.LogResponse;
import io.gravitee.repository.log.v4.model.message.MessageMetrics;
import io.gravitee.repository.log.v4.model.message.MessageMetricsQuery;
import io.gravitee.rest.api.model.analytics.SearchMessageLogsFilters;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.v4.log.SearchLogsResponse;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MessageLogsCrudServiceImpl
implements MessageLogsCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageLogsCrudServiceImpl.class);
    private final MetricsRepository metricsRepository;

    public MessageLogsCrudServiceImpl(@Lazy MetricsRepository metricsRepository) {
        this.metricsRepository = metricsRepository;
    }

    @Override
    public SearchLogsResponse<MessageLog> searchApiMessageLogs(ExecutionContext executionContext, String apiId, SearchMessageLogsFilters filters, Pageable pageable) {
        try {
            LogResponse response = this.metricsRepository.searchMessageMetrics(executionContext.getQueryContext(), MessageMetricsQuery.builder().filter(MessageMetricsQuery.Filter.builder().apiId(apiId).requestId(filters.requestId()).connectorId(filters.connectorId()).connectorType(filters.connectorType()).operation(filters.operation()).from(filters.from()).to(filters.to()).additional(filters.additional()).requiresAdditional(filters.requiresAdditional()).build()).page(pageable.getPageNumber()).size(pageable.getPageSize()).build());
            return this.mapToMessageResponse((LogResponse<MessageMetrics>)response);
        }
        catch (AnalyticsException e) {
            throw new TechnicalManagementException("An error occurs while searching message metrics for api [" + apiId + "]", e);
        }
    }

    private SearchLogsResponse<MessageLog> mapToMessageResponse(LogResponse<MessageMetrics> logs) {
        long total = logs.total();
        List<MessageLog> data = MessageLogAdapter.INSTANCE.mapToMessageMetrics(logs.data());
        return new SearchLogsResponse(total, data);
    }
}

