/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.portal_page.model.PortalArea;
import io.gravitee.apim.core.portal_page.model.PortalNavigationFolder;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemQueryCriteria;
import io.gravitee.apim.core.portal_page.model.PortalNavigationLink;
import io.gravitee.apim.core.portal_page.model.PortalNavigationPage;
import io.gravitee.apim.core.portal_page.model.PortalPageContentId;
import io.gravitee.apim.core.portal_page.model.PortalVisibility;
import io.gravitee.apim.infra.adapter.PortalNavigationItemAdapter;
import io.gravitee.repository.management.api.search.PortalNavigationItemCriteria;
import io.gravitee.repository.management.model.PortalNavigationItem;

public class PortalNavigationItemAdapterImpl
implements PortalNavigationItemAdapter {
    @Override
    public PortalNavigationLink portalNavigationLinkFromRepository(io.gravitee.repository.management.model.PortalNavigationItem portalNavigationItem) {
        if (portalNavigationItem == null) {
            return null;
        }
        String organizationId = null;
        String environmentId = null;
        String title = null;
        PortalArea area = null;
        Integer order = null;
        Boolean published = null;
        PortalVisibility visibility = null;
        PortalNavigationItemId id = null;
        organizationId = portalNavigationItem.getOrganizationId();
        environmentId = portalNavigationItem.getEnvironmentId();
        title = portalNavigationItem.getTitle();
        area = this.mapArea(portalNavigationItem.getArea());
        order = portalNavigationItem.getOrder();
        published = portalNavigationItem.isPublished();
        visibility = this.visibilityToPortalVisibility(portalNavigationItem.getVisibility());
        id = this.mapPortalNavigationItemId(portalNavigationItem.getId());
        String url = this.parseUrl(portalNavigationItem.getConfiguration());
        PortalNavigationLink portalNavigationLink = new PortalNavigationLink(id, organizationId, environmentId, title, area, order, url, published, visibility);
        portalNavigationLink.setParentId(this.mapPortalNavigationItemId(portalNavigationItem.getParentId()));
        return portalNavigationLink;
    }

    @Override
    public PortalNavigationPage portalNavigationPageFromRepository(io.gravitee.repository.management.model.PortalNavigationItem portalNavigationItem) {
        if (portalNavigationItem == null) {
            return null;
        }
        String organizationId = null;
        String environmentId = null;
        String title = null;
        PortalArea area = null;
        Integer order = null;
        Boolean published = null;
        PortalVisibility visibility = null;
        PortalNavigationItemId id = null;
        organizationId = portalNavigationItem.getOrganizationId();
        environmentId = portalNavigationItem.getEnvironmentId();
        title = portalNavigationItem.getTitle();
        area = this.mapArea(portalNavigationItem.getArea());
        order = portalNavigationItem.getOrder();
        published = portalNavigationItem.isPublished();
        visibility = this.visibilityToPortalVisibility(portalNavigationItem.getVisibility());
        id = this.mapPortalNavigationItemId(portalNavigationItem.getId());
        PortalPageContentId portalPageContentId = PortalPageContentId.of(this.parsePortalPageContentId(portalNavigationItem.getConfiguration()));
        PortalNavigationPage portalNavigationPage = new PortalNavigationPage(id, organizationId, environmentId, title, area, order, portalPageContentId, published, visibility);
        portalNavigationPage.setParentId(this.mapPortalNavigationItemId(portalNavigationItem.getParentId()));
        return portalNavigationPage;
    }

    @Override
    public io.gravitee.repository.management.model.PortalNavigationItem toRepository(PortalNavigationItem portalNavigationItem) {
        if (portalNavigationItem == null) {
            return null;
        }
        PortalNavigationItem.PortalNavigationItemBuilder portalNavigationItem1 = io.gravitee.repository.management.model.PortalNavigationItem.builder();
        portalNavigationItem1.id(this.mapPortalNavigationItemId(portalNavigationItem.getId()));
        portalNavigationItem1.organizationId(portalNavigationItem.getOrganizationId());
        portalNavigationItem1.environmentId(portalNavigationItem.getEnvironmentId());
        portalNavigationItem1.title(portalNavigationItem.getTitle());
        portalNavigationItem1.area(this.mapArea(portalNavigationItem.getArea()));
        portalNavigationItem1.parentId(this.mapPortalNavigationItemId(portalNavigationItem.getParentId()));
        portalNavigationItem1.order(portalNavigationItem.getOrder());
        if (portalNavigationItem.getPublished() != null) {
            portalNavigationItem1.published(portalNavigationItem.getPublished().booleanValue());
        }
        portalNavigationItem1.visibility(this.portalVisibilityToVisibility(portalNavigationItem.getVisibility()));
        portalNavigationItem1.type(this.mapType(portalNavigationItem));
        portalNavigationItem1.configuration(this.configurationOf(portalNavigationItem));
        return portalNavigationItem1.build();
    }

    @Override
    public PortalNavigationFolder portalNavigationFolderFromRepository(io.gravitee.repository.management.model.PortalNavigationItem portalNavigationItem) {
        if (portalNavigationItem == null) {
            return null;
        }
        String organizationId = null;
        String environmentId = null;
        String title = null;
        PortalArea area = null;
        Integer order = null;
        Boolean published = null;
        PortalVisibility visibility = null;
        PortalNavigationItemId id = null;
        organizationId = portalNavigationItem.getOrganizationId();
        environmentId = portalNavigationItem.getEnvironmentId();
        title = portalNavigationItem.getTitle();
        area = this.mapArea(portalNavigationItem.getArea());
        order = portalNavigationItem.getOrder();
        published = portalNavigationItem.isPublished();
        visibility = this.visibilityToPortalVisibility(portalNavigationItem.getVisibility());
        id = this.mapPortalNavigationItemId(portalNavigationItem.getId());
        PortalNavigationFolder portalNavigationFolder = new PortalNavigationFolder(id, organizationId, environmentId, title, area, order, published, visibility);
        portalNavigationFolder.setParentId(this.mapPortalNavigationItemId(portalNavigationItem.getParentId()));
        return portalNavigationFolder;
    }

    @Override
    public PortalNavigationItemCriteria map(PortalNavigationItemQueryCriteria criteria) {
        if (criteria == null) {
            return null;
        }
        PortalNavigationItemCriteria.PortalNavigationItemCriteriaBuilder portalNavigationItemCriteria = PortalNavigationItemCriteria.builder();
        if (criteria.getArea() != null) {
            portalNavigationItemCriteria.portalArea(criteria.getArea().name());
        }
        portalNavigationItemCriteria.environmentId(criteria.getEnvironmentId());
        portalNavigationItemCriteria.parentId(this.mapPortalNavigationItemId(criteria.getParentId()));
        portalNavigationItemCriteria.published(criteria.getPublished());
        portalNavigationItemCriteria.root(criteria.getRoot());
        if (criteria.getVisibility() != null) {
            portalNavigationItemCriteria.visibility(criteria.getVisibility().name());
        }
        return portalNavigationItemCriteria.build();
    }

    protected PortalVisibility visibilityToPortalVisibility(PortalNavigationItem.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case PortalNavigationItem.Visibility.PUBLIC -> PortalVisibility.PUBLIC;
            case PortalNavigationItem.Visibility.PRIVATE -> PortalVisibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(visibility));
        };
    }

    protected PortalNavigationItem.Visibility portalVisibilityToVisibility(PortalVisibility portalVisibility) {
        if (portalVisibility == null) {
            return null;
        }
        return switch (portalVisibility) {
            case PortalVisibility.PUBLIC -> PortalNavigationItem.Visibility.PUBLIC;
            case PortalVisibility.PRIVATE -> PortalNavigationItem.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)portalVisibility));
        };
    }
}

